/**
 *
 * @file mesh_2d_with_pkt_codec_sc_top.hh
 * @author Lasse Lehtonen
 *
 * @brief Foreign module declaration for mesh_2d_with_pkt_codec_top
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: mesh_2d_with_pkt_codec_sc_top.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */


#ifndef MESH_2D_SC_2_MESH_2D_WITH_PKT_CODEC_SC_TOP_HH
#define MESH_2D_SC_2_MESH_2D_WITH_PKT_CODEC_SC_TOP_HH

#include "sc_rtl_2/enc_dec_1d.hh"
#include "mesh_2d.hh"

#include <systemc>

namespace asebt
{
namespace mesh_2d_sc_2
{

   template < int n_ag_g, 
	      int stfwd_en_g, 
	      int data_width_g, 
	      int addr_width_g, 
	      int packet_length_g, 
	      int tx_len_width_g, 
	      int timeout_g, 
	      int fill_packet_g, 
	      int lut_en_g, 
	      int net_type_g, 
	      int len_flit_en_g, 
	      int oaddr_flit_en_g, 
	      int status_en_g, 
	      int fifo_depth_g, 
	      int mesh_freq_g, 
	      int ip_freq_g, 
	      int rows_g, 
	      int cols_g >
   class mesh_2d_with_pkt_codec_sc_top : public sc_core::sc_module
   {
   public:

      sc_core::sc_in_clk                clk_net;
      sc_core::sc_in_clk                clk_ip; 
      sc_core::sc_in<bool> rst_n;

      sc_core::sc_in<bool>               rx_av_in[n_ag_g];
      sc_core::sc_in<sc_dt::sc_bv<data_width_g> >   rx_data_in[n_ag_g];
      sc_core::sc_in<bool>               rx_we_in[n_ag_g];
      sc_core::sc_in<sc_dt::sc_bv<tx_len_width_g> > rx_txlen_in[n_ag_g];
      sc_core::sc_out<bool>              rx_full_out[n_ag_g];
      sc_core::sc_out<bool>              rx_empty_out[n_ag_g];
      sc_core::sc_out<bool>              tx_av_out[n_ag_g];
      sc_core::sc_out<sc_dt::sc_bv<data_width_g> >  tx_data_out[n_ag_g];
      sc_core::sc_in<bool>               tx_re_in[n_ag_g];
      sc_core::sc_out<bool>              tx_empty_out[n_ag_g];
  
  
      mesh_2d_with_pkt_codec_sc_top(sc_core::sc_module_name name)
	 : sc_core::sc_module(name),
	   clk_net("clk_net"),
	   clk_ip("clk_ip"),
	   rst_n("rst_n"),
	   enc_dec("enc_dec"),
	   mesh("mesh")
      {

	 enc_dec.clk(clk_ip);
	 enc_dec.rst_n(rst_n);
	 
	 mesh.rst_n(rst_n);
	 mesh.clk_mesh(clk_net);
	 mesh.clk_ip(clk_ip);

	 for(unsigned int i = 0; i < n_ag_g; ++i)
	 {
	    unsigned int r = i / cols_g;
	    unsigned int c = i % cols_g;

	    enc_dec.av_ip_enc_in[i](rx_av_in[i]);
	    enc_dec.data_ip_enc_in[i](rx_data_in[i]);
	    enc_dec.we_ip_enc_in[i](rx_we_in[i]);
	    enc_dec.len_ip_enc_in[i](rx_txlen_in[i]);
	    enc_dec.full_enc_ip_out[i](rx_full_out[i]);
	    enc_dec.empty_enc_ip_out[i](rx_empty_out[i]);
	    enc_dec.av_enc_net_out[i](av_enc_net[i]);
	    enc_dec.data_enc_net_out[i](data_enc_net[i]);
	    enc_dec.we_enc_net_out[i](we_enc_net[i]);
	    enc_dec.full_net_enc_in[i](full_net_enc[i]);
	    enc_dec.empty_net_enc_in[i](empty_net_enc[i]);
	    enc_dec.data_net_dec_in[i](data_net_dec[i]);
	    enc_dec.re_dec_net_out[i](re_dec_net[i]);
	    enc_dec.full_net_dec_in[i](full_net_dec[i]);
	    enc_dec.empty_net_dec_in[i](empty_net_dec[i]);
	    enc_dec.av_dec_ip_out[i](tx_av_out[i]);
	    enc_dec.data_dec_ip_out[i](tx_data_out[i]);
	    enc_dec.re_ip_dec_in[i](tx_re_in[i]);
	    enc_dec.empty_dec_ip_out[i](tx_empty_out[i]);

	    mesh.tx_data_in[r][c](data_enc_net[i]);
	    mesh.tx_we_in[r][c](we_enc_net[i]);
	    mesh.rx_re_in[r][c](re_dec_net[i]);
	    mesh.rx_data_out[r][c](data_net_dec[i]);
	    mesh.rx_empty_out[r][c](empty_net_dec[i]);
	    mesh.rx_full_out[r][c](full_net_dec[i]);
	    mesh.tx_full_out[r][c](full_net_enc[i]);
	    mesh.tx_empty_out[r][c](empty_net_enc[i]);
	 }

      }
  
      ~mesh_2d_with_pkt_codec_sc_top()
      {

      }
  
   private:
      
      sc_core::sc_signal<bool>             av_enc_net[n_ag_g];
      sc_core::sc_signal<sc_dt::sc_bv<data_width_g> > data_enc_net[n_ag_g];
      sc_core::sc_signal<bool>             we_enc_net[n_ag_g];
      sc_core::sc_signal<bool>             full_net_enc[n_ag_g];
      sc_core::sc_signal<bool>             empty_net_enc[n_ag_g];
      sc_core::sc_signal<sc_dt::sc_bv<data_width_g> > data_net_dec[n_ag_g];
      sc_core::sc_signal<bool>             re_dec_net[n_ag_g];
      sc_core::sc_signal<bool>             full_net_dec[n_ag_g];
      sc_core::sc_signal<bool>             empty_net_dec[n_ag_g];

      asebt::sc_rtl_2::enc_dec_1d<n_ag_g,
		 stfwd_en_g,
		 data_width_g,
		 addr_width_g,
		 packet_length_g,
		 tx_len_width_g,
		 timeout_g,
		 fill_packet_g,
		 lut_en_g,
		 0, // 0 = mesh
		 len_flit_en_g,
		 oaddr_flit_en_g,
		 status_en_g> enc_dec;

      mesh_2d<fifo_depth_g,
	      packet_length_g,
	      stfwd_en_g,
	      data_width_g,
	      addr_width_g,
	      len_flit_en_g,
	      oaddr_flit_en_g,
	      mesh_freq_g,
	      ip_freq_g,
	      rows_g,
	      cols_g> mesh;

   };

}
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
