/*
 * Created on 20.7.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.xml;

import java.io.StringReader;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.xml.sax.InputSource;

import fi.cpu.xml.bind.configuration.ConfigurationType;
import fi.cpu.xml.bind.measurement.MeasurementType;

/**
 * @author Timo Vanhatupa
 *
 * TODO To change the template for this generated type comment go to
 * Window - Preferences - Java - Code Style - Code Templates
 */
public class XML_Source_FPGA {

	public ConfigurationType getConfiguration(String configString) {
		try {
			ConfigurationType configuration = null;
			JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.configuration", this.getClass().getClassLoader());
			Unmarshaller u = jc.createUnmarshaller();
			u.setValidating(true);
			configuration = (ConfigurationType) u.unmarshal(new InputSource(new StringReader(configString)));
			return configuration;
		} catch (JAXBException e) {
			e.printStackTrace();
			System.out.println(configString);
			return null;
		}
	}
	
	public MeasurementType getMeasurement(String measurementString) {
		try {
			MeasurementType me = null;
			JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.measurement", this.getClass().getClassLoader());
			Unmarshaller u = jc.createUnmarshaller();
			u.setValidating(true);
			me = (MeasurementType) u.unmarshal(new InputSource(new StringReader(measurementString)));
			return me;
		} catch (JAXBException e) {
			e.printStackTrace();
			System.out.println(measurementString);
			return null;
		}
	}
}
