/*
 * CVS-tietoja:
 * $Author: perttul5 $ 
 * $Date: 2008-05-15 15:30:19 +0300 (to, 15 touko 2008) $ 
 * $Revision: 3504 $
 *
 * Created on 25.7.2005
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 *
 */
package fi.cpu.ui.graph;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Millisecond;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

import fi.cpu.Settings;
import fi.cpu.ui.MainWindow;

/**
 * @author jsikio
 *
 * SimpleChartFactory
 *
 */
public class SimpleChartFactory
{
    public static final int LINECHART_TYPE = 0;
    
    private static final int charts_ = 1;
    
    /*
     * 15.2.06 Timo Vanhatupa
     * Added command line parameter 'history'
     * Limits number of periods stored in chart
     * usage java -Dhistory=30 <classname>
     */
    public static final String PARAM_NAME_HISTORY_SIZE = "history";
    public static final String PARAM_VALUE_HISTORY_SIZE_UNLIMITED = "unlimited";
    
    public static String PARAM_HISTORY_SIZE = System.getProperty(PARAM_NAME_HISTORY_SIZE, PARAM_VALUE_HISTORY_SIZE_UNLIMITED);
    
    public static int historySize = -1;
    
    static {
        try {
        	if (PARAM_HISTORY_SIZE != null && !PARAM_VALUE_HISTORY_SIZE_UNLIMITED.equals(PARAM_HISTORY_SIZE)) {
        		historySize = Integer.parseInt(PARAM_HISTORY_SIZE);
        		System.out.println("History size will be changed to " + historySize + " item(s).");
        	} else {
        		historySize = Integer.parseInt(Settings.getAttributeValue("DEFAULT_HISTORY_SIZE"));
        	}
        } catch (Exception e) {
            historySize = -1;
        }
    }
    
    public static String[] getChartTypes()
    {
        String[] types = new String[ charts_ ];
        
        for( int i=0; i < charts_; i++ )
        {
            types[i] = getChartType( i );
        }
        
        return types;
        
    }
    
    public static String getChartType( int id )
    {
        return MainWindow.bundle.getString( "CHART_TYPE" + id );
    }
    
    public static JFreeChart createChart( int type, String title, String yAxis, String xAxis )
    {
        JFreeChart chart = null;
        
        switch( type )
        {
            case LINECHART_TYPE:
            {
                
                chart = createLineChart( title, yAxis, xAxis );
                
                break;
            }
            
            default:
            {
                break;
            }
        }
        
        return chart;
    }


    /**
     * @return
     */
    private static JFreeChart createLineChart( String title, String yAxis, String xAxis)
    {
        //TimeSeries series = new TimeSeries( xAxis, Millisecond.class );
        XYSeries series = new XYSeries( xAxis );
        if (historySize > 0) { 
//            series.setHistoryCount(historySize);
            series.setMaximumItemCount(historySize);
//            System.out.println("History size is " + historySize + " periods");
        }
        //TimeSeriesCollection seriesCollection = new TimeSeriesCollection( series );
        XYSeriesCollection seriesCollection = new XYSeriesCollection( series );
        //return ChartFactory.createTimeSeriesChart( title, xAxis, yAxis, seriesCollection, false, true, false );
        return ChartFactory.createXYLineChart( title, xAxis, yAxis, seriesCollection,
        		PlotOrientation.VERTICAL, false, true, false );
    }

}
