/**
 * File:    ModelNodeEvent.java
 * Author:  Tomi Jantti <tomi.jantti@tut.fi>
 * Created: 29.3.2007
 *
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.event;

import java.util.EventObject;

/**
 * ModelNodeEvent is used when notified about a change
 * in a ModelObject.
 */
public class ModelNodeEvent extends EventObject {
	private int eventId;
	private Object eventObject;
	
	/**
	 * Creates a new ModelNodeEvent.
	 * @param source  Instance of ModelNode.
	 * @param eventId Id of the event.
	 */
	public ModelNodeEvent(Object source, int eventId) {
		super(source);
		this.eventId = eventId;
		this.eventObject = null;
	}


	/**
	 * Creates a new ModelNodeEvent.
	 * @param source      Instance of ModelNode.
	 * @param eventId     Id of the event.
	 * @param eventObject Object related to the event.
	 */
	public ModelNodeEvent(Object source, int eventId, Object eventObject) {
		super(source);
		this.eventId = eventId;
		this.eventObject = eventObject;
	}

	
	/**
	 * @return Returns the eventId.
	 */
	public int getEventId() {
		return eventId;
	}
	
	
	/**
	 * @return Returns the eventObject.
	 */
	public Object getEventObject() {
		return eventObject;
	}
}
