/**
 *
 * @file non_sc_factory.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: non_sc_factory.cc 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */

#include "non_sc_factory.hh"
#include "tcp_server.hh"

namespace sctg
{
  NonScFactory::NonScFactory(sctg::NonScConfIf& conf)
  :
    _conf(conf),
    _tcpServerIf(0)
  {
    _tcpServerIf = new TcpServer(9990);
    _conf.setTcpServer(_tcpServerIf);
  }

  NonScFactory::~NonScFactory()
  {
    delete _tcpServerIf; _tcpServerIf = 0;
  }


}

// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
