/**
 *
 * @file common.cc
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: common.cc 1916 2011-07-06 12:44:26Z lehton87 $
 *
 */

#include "common.hh"

namespace sctg
{
  
   std::string stateToString(State state)
   {
      switch(state)
      {
	 case RUN: return "RUN"; break;
	 case WAIT: return "WAIT"; break;
	 case FREE: return "FREE"; break;
	 case READY: return "READY"; break;
	 default: return "SOMETHING IS WRONG"; break;
      }
   }

}


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
