/**
 *
 * @file resource_user.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: configuration.hh 1506 2011-01-05 13:41:03Z lehton87 $
 *
 */


#ifndef SCTG_RESOURCE_USER_HH
#define SCTG_RESOURCE_USER_HH

#include "configuration.hh"

#include <boost/property_tree/ptree.hpp>

#include <string>

namespace sctg
{
   /** Base class for Task and MemArea classes
    *
    *
    */
   class ResourceUser
   {
   public:
      /** Constructor
       */
      ResourceUser(const boost::property_tree::ptree& pt,
		   Configuration& config);
      
      /** Destructor
       */
      virtual ~ResourceUser();
      
      /** Returns name
       */
      const std::string& getName();

      /** Returns class
       */
      const std::string& getClass();

      /** Returns ID
       */
      unsigned long int  getId();

      /** Returns all out_ports
       */
      std::vector<unsigned long int>& getOutPorts();

      /** Returns all in_ports
       */
      std::vector<unsigned long int>& getInPorts();
      
   protected:
      
      /** Name
       */
      std::string       _name;  
      /** Unique ID number
       */
      unsigned long int _id;    
      /** Class name
       */
      std::string       _class; 
      /** Reference to Configuration object
       */
      Configuration&    _config;
      
      /** Owned in_ports
       */
      std::vector<unsigned long int> _inPorts;
      /** Owned out_ports
       */
      std::vector<unsigned long int> _outPorts;

   private:

      
      
  };
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:

