/**
 *
 * @file mem_area.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it
 *  and/or modify it under the terms of the Lesser GNU General Public
 *  License as published by the Free Software Foundation, either
 *  version 3 of the License, or (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be
 *  useful, but WITHOUT ANY WARRANTY; without even the implied
 *  warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public
 *  License along with Transaction Generator.  If not, see
 *  <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: tg_token.hh 1399 2010-08-26 13:56:45Z lehton87 $
 *
 */

#ifndef SCTG_MEM_AREA_HH
#define SCTG_MEM_AREA_HH


#include "resource_user.hh"


namespace sctg
{
   /** Defines a memory area 
    *
    */
   class MemArea : public ResourceUser
   {
   public:
      
      /** Contructor
       */
      MemArea(const boost::property_tree::ptree& pt,
	      Configuration& config);

      /** Destructor
       */
      virtual ~MemArea();

      /** Returns the size of the memory area in bytes
       */      
      unsigned long int getSize() const;

   private:

      unsigned long int size_;
           
   };
}

#endif

// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
