/**
 *
 * @file crossbar_factory.hh
 * @author Lasse Lehtonen
 *
 *
 */

/*
 * Copyright 2010 Tampere University of Technology
 * 
 *  This file is part of Transaction Generator.
 *
 *  Transaction Generator is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Transaction Generator is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Transaction Generator.  If not, see <http://www.gnu.org/licenses/>.
 */

/*
 * $Id: crossbar_factory.hh 1942 2011-08-17 07:34:03Z lehton87 $
 *
 */

#ifndef CROSSBAR_NOC_FACTORY_HH
#define CROSSBAR_NOC_FACTORY_HH


// Using VHDL NoCs only when mixed language simulation is enabled
#ifdef SCTG_MIXED_LANGUAGE_SIM
#include "vhd/crossbar_factory_vhd.hh"
#endif

#include "noc_conf_if.hh"

#include <systemc>

namespace sctg
{
   
   class CrossbarFactory
   {
   public:
      
      CrossbarFactory(sctg::NocConfIf* nocConfIf);
      
      virtual ~CrossbarFactory();      
      
   private:   
            
// Using VHDL NoCs only when mixed language simulation is enabled
#ifdef SCTG_MIXED_LANGUAGE_SIM
      sctg::crossbar_vhd::CrossbarFactoryVHD* _crossbar_vhd;
#endif
      
      CrossbarFactory(const CrossbarFactory&);
      CrossbarFactory& operator=(const CrossbarFactory&);
   };
   
}

#endif


// Local Variables:
// mode: c++
// c-file-style: "ellemtel"
// c-basic-offset: 3
// End:
