/*
 * Created on 20.7.2005
 *
 * TODO To change the template for this generated file go to
 * Window - Preferences - Java - Code Style - Code Templates
 *
 *
 * Copyright 2009 Tampere University of Technology
 * 
 *  This file is part of Execution Monitor.
 *
 *  Execution Monitor is free software: you can redistribute it and/or modify
 *  it under the terms of the Lesser GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  Execution Monitor is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  Lesser GNU General Public License for more details.
 *
 *  You should have received a copy of the Lesser GNU General Public License
 *  along with Execution Monitor.  If not, see <http://www.gnu.org/licenses/>.
 *
 *
 */
package fi.cpu.ui.xml;

import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

import org.xml.sax.InputSource;

import fi.cpu.xml.bind.configuration.ObjectFactory;
import fi.cpu.xml.bind.systemconfig.SystemConfigType;


/**
 * @author Timo Vanhatupa
 * 
 * TODO To change the template for this generated type comment go to Window -
 * Preferences - Java - Code Style - Code Templates
 */
public class SystemConfigMarshaller {

	public SystemConfigType loadSystemConfig(InputStream configStream) throws JAXBException {
		SystemConfigType systemconfig = null;
		JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.systemconfig",
				this.getClass().getClassLoader());
		Unmarshaller u = jc.createUnmarshaller();
		u.setValidating(true);
		
		systemconfig = (SystemConfigType) u.unmarshal(new InputSource(configStream));
		return systemconfig;
	}

	public void saveSystemConfig(String configFile, SystemConfigType systemConfig)
			throws JAXBException, IOException {
		JAXBContext jc = JAXBContext.newInstance("fi.cpu.xml.bind.systemconfig",
				this.getClass().getClassLoader());
		Marshaller u = jc.createMarshaller();
		u.setProperty(Marshaller.JAXB_FORMATTED_OUTPUT, Boolean.TRUE);
		
		FileWriter writer = new FileWriter(configFile);
		
		u.marshal(systemConfig, writer);
		writer.close();
	}

	public ObjectFactory getObjectFactory() {
		ObjectFactory of = new ObjectFactory();
		return of;
	}
}