
#include "command_line.h"


void process_command_line(int   argc,
                          char* argv[],
                          std::string& ocp_params_file_name)
{
    // get the ocp parameters file name
    ocp_params_file_name = "";
    if (argc > 1) {
        std::string file_name(argv[1]);
        ocp_params_file_name = file_name;
    }
}

void process_command_line(int   argc,
                          char* argv[],
                          std::string& ocp_params_file_name1,
                          std::string& ocp_params_file_name2)
{
    // get the ocp parameters file name
    ocp_params_file_name1 = "";
    ocp_params_file_name2 = "";
    if (argc > 2) {
        std::string file_name1(argv[1]);
        ocp_params_file_name1 = file_name1;
        std::string file_name2(argv[2]);
        ocp_params_file_name2 = file_name2;
    }
}

void readMapFromFile(const std::string &myFileName, map_string_type &myParamMap) 
{
    // read pairs of data from the passed file
    std::string leftside;
    std::string rightside;
    
    // (1) open the file
    std::ifstream inputfile(myFileName.c_str());
    assert( inputfile );

    // set the formatting
    inputfile.setf(std::ios::skipws);

    // Now read through all the pairs of values and add them to the passed map
    while ( inputfile ) {
        inputfile >> leftside;
        inputfile >> rightside;
        myParamMap.insert(std::make_pair(leftside,rightside));
    }

    // All done, close up
    inputfile.close();
}
