/* Copyright
 * ========================================================================================
 * Project:		Accurate DRAM Model
 * Author:		Yi Wang, Nan Li, KTH
 * ID:			adm_dram_ctrl_ifs.h, v1.3, 2010/12/08
 *
 * Description:	Define internal interfaces between DRAM and the controller
 *
 * ========================================================================================
 * Version History
 * ========================================================================================
 * Version 1.3: Add methods virtualDelay() and getRemainCycles() to adm_core_if interface
 * Version 1.2: Add method coreReactive() for model the delay after a refresh
 * Version 1.1: Add a new interface for Inner communication between command decoder and the
 * 				very physical core.
 * Version 1.0:	Removed getRequest() and getResponse(), and split putRequest() into
 * 				putReadRequest() and putWriteRequest()
 * Version 0.1: Draft version
 * ========================================================================================
 */

#ifndef ADM_DRAM_CTRL_IFS_H_
#define ADM_DRAM_CTRL_IFS_H_

#include "systemc.h"
#include "adm_basic_types.h"

class adm_ctrl_if: public virtual sc_interface {
public:
	virtual bool putResponse(const adm_data &rsp) = 0;
};

class adm_dram_if : public virtual sc_interface {
public:
	virtual bool putReadRequest(uint64 address, int length) = 0;
	virtual bool putWriteRequest(uint64 address, const adm_data &data) = 0;
};

class adm_core_if : public virtual sc_interface {
public :
	virtual void coreHopRow() = 0;
	virtual void coreRead(uint64 address, int length, int tHopRow, int burstCycle) = 0;
	virtual void coreWrite(uint64 address, const adm_data &data, const int tPreparation, const int burstCycle) = 0;
	virtual void coreReactivate() = 0;
	virtual void virtualDelay(int delay) = 0;
	virtual int getRemainCycles() = 0;
};

#endif /* ADM_DRAM_CTRL_IFS_H_ */
