// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level 
//       Author : Alan Kamas, for Sonics, Inc.
//         Date : 09/15/2003
//
//  Description : Extends the Event Finder from SystemC to find events on a 
//                particular port of a multi-port channel.
//                Note that since the SystemC sc_event_finder_t class contains
//                private members that this class would need access to,
//                this class copies and extends the class rather than
//                inheriting from it.
//
// ============================================================================

#ifndef MULTIPORT_EVENT_FINDER_H
#define MULTIPORT_EVENT_FINDER_H

#include "systemc/communication/sc_event_finder.h"

template <class IF>
class multiport_event_finder_t
: public sc_event_finder
{
public:

    // constructor
    multiport_event_finder_t( const sc_port<IF,0>& port_,
            const sc_event& (IF::*event_method_) () const,
            int portNum_)
        : sc_event_finder( port_ ), m_sc_port(port_), m_event_method( event_method_ ), m_portNum(portNum_)
    {
        // do nothing
    }

    // destructor (does nothing)
    virtual ~multiport_event_finder_t()
    {
        // do nothing 
    }

    virtual const sc_event& find_event() const;

protected:
    const sc_port<IF,0>& m_sc_port;
    const sc_event& (IF::*m_event_method) () const;
    int m_portNum;

};


// IIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIIII

template <class IF>
inline
const sc_event&
multiport_event_finder_t<IF>::find_event() const
{
    const IF* iface = DCAST<const IF*>( m_sc_port[m_portNum] );
    if( iface == 0 ) {
        report_error( SC_ID_FIND_EVENT_, "passed port number is not bound" );
    }
    return (CCAST<IF*>( iface )->*m_event_method) ();
}

#endif   // MULTIPORT_EVENT_FINDER_H
