// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - Layer-2 Simple Example slave
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  last_request = OCP_MCMD_IDLE;

  SC_THREAD(proc_req);
  SC_THREAD(proc_resp);
  sensitive(send_response_event);
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc_req()
//
//  Slave request process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void Slave<TdataCl>::proc_req(){
  bool release = false;
  unsigned int size;
  bool last = true;
  sc_time delay = sc_time(2, SC_NS);

  while (true) {
    is_req = tpP->getOCPRequestBlocking(req, release, size, last); // accept automatically
    if (is_req) {
      tpP->putSCmdAccept(delay);
      // If request was write
      if (req.MCmd == OCP_MCMD_WR) {
#ifdef DEBUG_G1
	cout << "Slave got write request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  data  = " << req.MDataPtr[0] << endl;
#endif

      }
      else if (req.MCmd == OCP_MCMD_RD) {
	
#ifdef DEBUG_G1
	cout << "Slave got read request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  address  = " << req.MAddr << endl;
#endif
	send_response_event.notify(delay);
      }
    }
  }
} // end of method

// ----------------------------------------------------------------------------
//  Method : Slave::proc_resp()
//
//  Slave response process
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Slave<TdataCl>::proc_resp(){
  Td SData = 0;
  resp.SDataPtr = &SData;
  while(true) {
    wait(); // for response event

    // Set OCP response
    resp.SResp = OCP_SRESP_DVA;

#ifdef DEBUG_G1
    cout << "Slave sent response " << resp.SResp
	 << " time " << sc_time_stamp().to_seconds()
	 << " data " << resp.SDataPtr[0] << endl;
#endif

    // Send response
    tpP->startOCPResponseBlocking(resp);
      
    SData++;
  }
} // end of method


// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class Slave< OCP_TL2_SIGNAL_CL >; // see ocp_tl2_globals.h

