// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP - TL1 example Slave
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H
#define DEBUG_G1
#include <iostream>
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_tl1_slave_port.h"
#include "ocp_tl_param_cl.h"

template <typename TdataCl>
class Slave : public sc_module {
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  OCP_TL1_SlavePort<TdataCl> tpP;

  SC_HAS_PROCESS(Slave);

  // constructor
  Slave(sc_module_name name_);

  // destructor
  ~Slave();

  // Threads
  void proc();

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP response group
  OCPResponseGrp<Td> resp;

  bool is_req;
  bool tmp;
  int last_request;

};

#endif
