// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP - TL1 example Master
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_SYNC_H
#define _OCP_TL1_MASTER_SYNC_H
#define DEBUG_G1
#include <iostream>
#include "stdlib.h"

// User defined types
#include "channel_types.h"

// OCP-IP Channel header files
#include "ocp_globals.h"
#include "ocp_tl1_master_port.h"
#include "ocp_tl_param_cl.h"

template <typename TdataCl>
class Master : public sc_module
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // channel port
  OCP_TL1_MasterPort<TdataCl> ipP;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc();

  bool tmp;
  int cnt;

  // Request group
  OCPRequestGrp<Td,Ta> req;
  // Response group
  OCPResponseGrp<Td> resp;

};


#endif // _OCP_TL1_MASTER_SYNC_H
