// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 03/31/2004
//
//  Description : OCP API - TL-1 Constructor examples
//
// ============================================================================

// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

// Include OCP files
#include "ocp_tl1_data_cl.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_channel.h"

// Include user-defined headers
#include "channel_types.h"
#include "command_line.h"

// Include submodules
#include "master.h"
#include "slave.h"

// Create a toggling signal 
class my_clk : public sc_module
{
public:  
  
  sc_out<bool>  clk;
  SC_HAS_PROCESS(my_clk);

  // constructor
  my_clk(sc_module_name name_, double p=1, sc_time_unit t=SC_NS)  {
    m_p = p;
    m_t = t;
    SC_THREAD(c);
  }

  void c() {
    bool clk_t = 1;
    while(1) {
      clk = clk_t;
      wait(m_p/2,m_t);
      clk_t = !clk_t;
    }
  }
private:
  double m_p; 
  sc_time_unit m_t;

};

// Instantiates a few different channels
class top : public sc_module
{
public:  
  
  sc_in_clk  clk;


  // constructor
  top(sc_module_name name_, 
      MapStringType  ocpParamMap,
      bool use_event,
      bool use_default_event,
      double clock_period,
      std::string monFileName3,
      std::string monFileName4,
      std::string monFileName5
      ) 
  {

    // default constructor
    ch2 = new OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ("ocp2");

    // full constructor
    ch3 = new OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ("ocp3",
										  (bool) true,
										  (bool) use_event,
										  (bool) use_default_event,
										  (sc_trace_file*) NULL, //not supported
										  (double) clock_period,
										  (sc_time_unit) SC_NS,
										  (std::string) monFileName3,
										  (bool) false
										  );
    
    // self timed constructor
    ch4 = new OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ("ocp4",
										  (double) clock_period,
										  (sc_time_unit) SC_NS,
										  (std::string) monFileName4
										  );

    // clocked channel with input port as clock
    ch5 = new OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ("ocp5",
										  (sc_in_clk *) &clk,
										  (std::string) monFileName5
										  );


    sl2 = new Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("sl2");
    ms2 = new Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("ms2");
    sl3 = new Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("sl3");
    ms3 = new Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("ms3");
    sl4 = new Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("sl4");
    ms4 = new Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("ms4");
    sl5 = new Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("sl5");
    ms5 = new Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > >("ms5");

    ch2->setConfiguration(ocpParamMap);
    ch3->setConfiguration(ocpParamMap);
    ch4->setConfiguration(ocpParamMap);
    ch5->setConfiguration(ocpParamMap);



    ms2->ipP(*ch2);
    sl2->tpP(*ch2);
    ms3->ipP(*ch3);
    sl3->tpP(*ch3);
    ms4->ipP(*ch4);
    sl4->tpP(*ch4);
    ms5->ipP(*ch5);
    sl5->tpP(*ch5);

  };



  OCP_TL1_Channel< OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > *ch2;
  OCP_TL1_Channel< OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > *ch3;
  OCP_TL1_Channel< OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > *ch4;
  OCP_TL1_Channel< OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > *ch5;

  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *sl2;
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *ms2;
  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *sl3;
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *ms3;
  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *sl4;
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *ms4;
  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *sl5;
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > *ms5;

};

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  MapStringType  ocpParamMap;
  string ocpParamFileName;

  // Command line parameters
  bool use_event;
  bool use_default_event;
  double clock_period;
  std::string monFileName0;
  std::string monFileName1;
  std::string monFileName3;
  std::string monFileName4;
  std::string monFileName5;


  sc_clock clk("clk", 1, SC_NS);


  // Read command line parameters
  process_command_line(argc,argv,
		       ocpParamFileName,
		       use_event,
		       use_default_event,
		       clock_period,
		       monFileName0,
		       monFileName1,
		       monFileName3,
		       monFileName4,
		       monFileName5
		       );

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, 
		    ocpParamMap
		    );
  }


  sc_signal<bool> clk1;

  // clocked channel with clock generator as clock
  OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ch0("ocp0",
  									 (sc_clock *) &clk,
  									 (std::string) monFileName0
  									 );
  ch0.setConfiguration(ocpParamMap);


  // clocked channel with signal as clock
  OCP_TL1_Channel<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32> > ch1("ocp1",
									 (sc_signal<bool> *) &clk1,
									 (std::string) monFileName1
									 );
  ch1.setConfiguration(ocpParamMap);

  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > sl0("sl0");
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > ms0("ms0");
  Slave<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > sl1("sl1");
  Master<OCP_TL1_DataCl<OCPCHANNELBit32, OCPCHANNELBit32 > > ms1("ms1");

  my_clk clk2("clk2", 1, SC_NS);

  ms0.ipP(ch0);
  sl0.tpP(ch0);
  ms1.ipP(ch1);
  sl1.tpP(ch1);
  clk2.clk(clk1);


  // Add some hierarchy
  top t("top", 
	ocpParamMap,
	use_event,
	use_default_event,
	clock_period,
	monFileName3,
	monFileName4,
	monFileName5
	); 

  t.clk(clk);

  // Simulator
  sc_start(50, SC_NS);
  
  return(0);
}
