// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 04/09/2004
//
//  Description :  TL1 example Master
//
// ============================================================================

#ifndef _TL1_MASTER_SYNC_H
#define _TL1_MASTER_SYNC_H

// Turn on printouts
#define DEBUG_G1

#include <iostream>
#include "stdlib.h"

// User defined types
#include "channel_types.h"

// TLM classes
#include "ocp_globals.h"
#include "ocp_tl1_data_cl.h"
#include "tl_master_if.h"

template <typename TdataCl> class Master
  : public sc_module
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port< TLmasterIF<TdataCl>, 1> ipP;

  sc_in_clk clk;

  SC_HAS_PROCESS(Master);

  // constructor
  Master(sc_module_name name_);

  // destructor
  ~Master();

  // threads
  void proc_req();
  void proc_resp();

  bool tmp;
  int cnt;

  // OCP request group
  OCPRequestGrp<Td,Ta> req;

  // OCP response group
  OCPResponseGrp<Td> resp;

private:

  //
  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl*          m_DataCl;
  ParamCl<TdataCl>* m_ParamCl;
};


#endif // TL1_MASTER_SYNC_H
