// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         Date : 04/09/2004
//
//  Description : Generic API - Layer-1 Simple Example
//                Top level
//
// ============================================================================


// Turn off OCP protocol checker, if installed
#define NDEBUG

// Include SystemC
#include "systemc.h"

#include "ocp_tl_param_cl.h" 

// Include submodules
#include "master.h"
#include "slave.h"

#include "ocp_tl1_data_cl.h"
#include "tl_channel.h"



int sc_main(int argc, char* argv[]) {

  // Clock generator
  sc_clock clk;

  // OCP Channel declaration
  TL_Channel<OCP_TL1_DataCl<int, int >  > ch0("ch0");

  // Set the OCP parameters
  ch0.GetParamCl()->respaccept=true;

  // Submodules
  Slave<OCP_TL1_DataCl< int, int > > sl1("sl1");
  Master<OCP_TL1_DataCl< int, int > > ms1("ms1");

  // Netlist
  ms1.ipP(ch0);
  ms1.clk(clk);
  sl1.tpP(ch0);
  sl1.clk(clk);

  // Simulator
  sc_start(50, SC_NS);

  return(0);
}
