// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Alan Kamas, for Sonics Inc.
//                Yann Bajot, Prosilog
//                Anssi Haverinen, Nokia Inc.
//                
//         Date: 03/30/2004
//
//  Description : Slave Interface for the OCP TL1 Channel
//
//
//  Change History
//             12/14/2003 Original revision for OCP 2.0
//             03/30/2004 Added putSCmdAccept(bool), putSDataAccept(bool)
// ============================================================================//


#ifndef _OCP_TL1_SLAVE_IF
#define _OCP_TL1_SLAVE_IF

#include "systemc.h"
#include "tl_slave_if.h"

// OCP specific header files
#include "ocp_globals.h"

template <class TdataCl>
class OCP_TL1_SlaveIF : virtual public TLslaveIF<TdataCl>
{
  public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  //////////////////////////////////////////////////////////////
  // OCP TL1 specific methods
  //////////////////////////////////////////////////////////////

  //---------------------------------------------------------------------
  // public OCP methods for the request phase
  //---------------------------------------------------------------------
  virtual bool getOCPRequest(OCPRequestGrp<Td,Ta>& req, bool accept) = 0;
  virtual bool getOCPRequest(OCPRequestGrp<Td,Ta>& req) = 0;
  virtual bool getOCPRequestBlocking(OCPRequestGrp<Td,Ta>& req, bool accept) = 0;
  virtual bool getOCPRequestBlocking(OCPRequestGrp<Td,Ta>& req) = 0;
  virtual bool putSCmdAccept() = 0;
  virtual void putSCmdAccept(bool scmdccept) = 0;
  virtual void putSThreadBusy(unsigned int sthreadbusy) = 0;
  virtual void putNextSThreadBusy(unsigned int sthreadbusy) = 0;
  virtual const sc_event& RequestStartEvent(void) const = 0; 
  virtual const sc_event& RequestEndEvent(void) const = 0; 

  //---------------------------------------------------------------------
  // public OCP methods for the response phase
  //---------------------------------------------------------------------
  virtual bool getMBusy(void) const = 0;
  virtual unsigned int getMThreadBusy(void) const = 0;
  virtual bool startOCPResponse(OCPResponseGrp<Td>& resp) = 0;
  virtual bool startOCPResponseBlocking(OCPResponseGrp<Td>& resp) = 0;
  virtual bool getMRespAccept(void) const = 0;
  virtual void waitMRespAccept(void) = 0;
  virtual const sc_event& ResponseStartEvent(void) const = 0; 
  virtual const sc_event& ResponseEndEvent(void) const = 0; 

  //---------------------------------------------------------------------
  // public OCP methods for the data phase
  //---------------------------------------------------------------------
  virtual bool getOCPDataHS(OCPDataHSGrp<Td>& datahs, bool accept) = 0;
  virtual bool getOCPDataHS(OCPDataHSGrp<Td>& datahs) = 0;
  virtual bool getOCPDataHSBlocking(OCPDataHSGrp<Td>& datahs, bool accept) = 0;
  virtual bool getOCPDataHSBlocking(OCPDataHSGrp<Td>& datahs) = 0;
  virtual bool putSDataAccept(void) = 0;
  virtual void putSDataAccept(bool dataaccept) = 0;
  virtual void putSDataThreadBusy(unsigned int sdatathreadbusy) = 0;
  virtual void putNextSDataThreadBusy(unsigned int sdatathreadbusy) = 0;
  virtual const sc_event& DataHSStartEvent(void) const = 0; 
  virtual const sc_event& DataHSEndEvent(void) const = 0; 

  //---------------------------------------------------------------------
  // public OCP Timing Methods
  //---------------------------------------------------------------------
  virtual void ocpWait(double count = 1) = 0;
  virtual bool ocpSafeWait(double count = 1) = 0;

  //---------------------------------------------------------------------
  // public OCP Reset Methods
  //---------------------------------------------------------------------
  virtual bool getReset(void) = 0;
  virtual void SResetAssert(void) = 0;
  virtual void SResetDeassert(void) = 0;
  virtual const sc_event& ResetStartEvent(void) const = 0;
  virtual const sc_event& ResetEndEvent(void) const = 0;

  //---------------------------------------------------------------------
  // public OCP Slave Sideband Commands
  //---------------------------------------------------------------------
  virtual bool SgetMError(void) const = 0;
  virtual unsigned int SgetMFlag(void) const = 0;
  virtual void SputSError(bool nextValue) = 0;
  virtual void SputSFlag(unsigned int nextValue) = 0;
  virtual void SputSFlag(unsigned int nextValue, unsigned int mask) = 0;
  virtual void SputSInterrupt(bool nextValue) = 0;

  //---------------------------------------------------------------------
  // public OCP Slave Sideband Events
  //---------------------------------------------------------------------
  virtual const sc_event& SidebandMErrorEvent(void) const = 0; 
  virtual const sc_event& SidebandMFlagEvent(void) const = 0; 

  //---------------------------------------------------------------------
  // public OCP System Sideband Commands
  //---------------------------------------------------------------------
  virtual bool SysputControl(int nextValue) = 0;
  virtual bool SysgetControlBusy(void) const = 0;
  virtual void SysputControlWr(bool nextValue) = 0;
  virtual int SysgetStatus(void) const = 0;
  virtual bool readStatus(int& currentValue) const = 0;
  virtual bool SysgetStatusBusy(void) const = 0;
  virtual void SysputStatusRd(bool nextValue) = 0;

  //---------------------------------------------------------------------
  // public OCP System Sideband Events
  //---------------------------------------------------------------------
  virtual const sc_event& SidebandControlBusyEvent(void) const = 0;
  virtual const sc_event& SidebandStatusEvent(void) const = 0;
  virtual const sc_event& SidebandStatusBusyEvent(void) const = 0;

  //---------------------------------------------------------------------
  // public OCP Core Sideband Commands
  //---------------------------------------------------------------------
  virtual int CgetControl(void) const = 0;
  virtual void CputControlBusy(bool nextValue) = 0;
  virtual bool CgetControlWr(void) const = 0;
  virtual void CputStatus(int nextValue) = 0;
  virtual void CputStatusBusy(bool nextValue) = 0;
  virtual bool CgetStatusRd(void) const = 0;
                                      
  //---------------------------------------------------------------------
  // public OCP Core Sideband Events
  //---------------------------------------------------------------------
  virtual const sc_event& SidebandControlEvent(void) const = 0;
  virtual const sc_event& SidebandControlWrEvent(void) const = 0;
  virtual const sc_event& SidebandStatusRdEvent(void) const = 0;

  //---------------------------------------------------------------------
  // old OCP methods for the request phase
  //---------------------------------------------------------------------
  /************* These commands no longer supported ****************
  virtual bool getRequest(OCPRequestGrp<Td,Ta>& req, bool accept) = 0;
  virtual bool getRequest(OCPRequestGrp<Td,Ta>& req) = 0;
  virtual bool getRequestBlocking(OCPRequestGrp<Td,Ta>& req, bool accept) = 0;
  virtual bool getRequestBlocking(OCPRequestGrp<Td,Ta>& req) = 0;
  virtual bool putSCmdAccept() = 0;
  virtual void putSThreadBusy(unsigned int sthreadbusy) = 0;
  ************* These commands no longer supported ****************/


  //---------------------------------------------------------------------
  // old OCP methods for the response phase
  //---------------------------------------------------------------------
  /************* These commands no longer supported ****************
  virtual bool putResponse(OCPResponseGrp<Td>& resp) = 0;
  virtual bool putResponseBlocking(OCPResponseGrp<Td>& resp) = 0;
  virtual void putNullSResp(void) const = 0;
  virtual bool getMRespAccept(void) const = 0;
  virtual unsigned int getMThreadBusy(void) const = 0;
  virtual void waitMRespAccept(void) = 0;
  ************* These commands no longer supported ****************/

  //---------------------------------------------------------------------
  // old OCP methods for the data phase
  //---------------------------------------------------------------------
  /************* These commands no longer supported ****************
  virtual bool getData(OCPDataHSGrp<Td>& datahs, bool accept) = 0;
  virtual bool getData(OCPDataHSGrp<Td>& datahs) = 0;
  virtual bool getDataBlocking(OCPDataHSGrp<Td>& datahs, bool accept) = 0;
  virtual bool getDataBlocking(OCPDataHSGrp<Td>& datahs) = 0;
  virtual bool putSDataAccept(void) = 0;
  virtual void putSDataThreadBusy(unsigned int sdatathreadbusy) = 0;
  ************* These commands no longer supported ****************/

  ///////////////
  // Generic Methods kept for backward compatibility
  ///////////////

  // Generic Methods for getting requests and sending responses.
  virtual void Srelease() = 0;
  virtual void SreleasePE() = 0;
  virtual void SunreleasePE() = 0;
  virtual void Srelease(sc_time) = 0;
  virtual bool SgetRequest(bool) = 0;
  virtual bool SgetRequestBlocking(bool) = 0;
  virtual bool SgetRequestPE() = 0;
  virtual bool SputResponse() = 0;
  virtual bool SputResponseBlocking() = 0;
  virtual bool IsWrite() = 0;
  virtual bool SgetMbusy() const = 0;

  // Generic second request channel (data handshake)
  virtual void SreleaseData() = 0;
  virtual void SreleaseDataPE() = 0;
  virtual void SunreleaseDataPE() = 0;
  virtual void SreleaseData(sc_time) = 0;
  virtual bool SgetDataRequest(bool) = 0;
  virtual bool SgetDataRequestBlocking(bool) = 0;
  virtual bool SgetDataRequestPE() = 0;

  // Generic default event.
  // This event is triggered if an Mput or an Sput method is called
  // in the Channel connected to the Slave.
  virtual const sc_event& default_event() const = 0;

  // Generic access methods to the user defined data structures of the Channel.
  virtual TdataCl          *GetDataCl()  = 0;
  virtual ParamCl<TdataCl> *GetParamCl() = 0;
  virtual CommCl           *GetCommCl()  = 0;

  // Generic direct access method Slave to Master direction.
  virtual bool SputDirect(int, bool, Td*, Ta, int) = 0;
  virtual void SregisterDirectIF(SdirectIF<TdataCl>*) = 0;

};

#endif // _OCP_TL1_SLAVE_IF
