// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Norman Weyrich, Synopsys Inc.
//                Alan Kamas, for Sonics Inc.
//                Yann Bajot, Prosilog
//                Anssi Haverinen, Nokia Inc.
//         Date : 02/03/2004
//
//  Description : Transaction Level Slave interface declaration.
//                These methods are implemented in the Channel
//                (see tl_channel.h)
//
//  Change History
//             12/14/2003 Original revision for OCP 2.0
//             02/03/2004 Added SunreleasePE(), SunreleaseDataPE()
// ============================================================================//


#ifndef _TL_SLAVE_IF
#define _TL_SLAVE_IF

#include "systemc.h"


// forward declaration of parameter class
template <class TdataCl> class ParamCl;

#include "tl_comm_cl.h"
#include "tl_direct_if.h"

template <class TdataCl> class TLslaveIF 
  : public SdirectIF<TdataCl>
{
  public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Methods for getting requests and sending responses.
  virtual void Srelease() = 0;
  virtual void SreleasePE() = 0;
  virtual void SunreleasePE() = 0; // AHa Feb 04 Added
  virtual void Srelease(sc_time) = 0;
  virtual bool SgetRequest(bool) = 0;
  virtual bool SgetRequestBlocking(bool) = 0;
  virtual bool SgetRequestPE() = 0;
  virtual bool SputResponse() = 0;
  virtual bool SputResponseBlocking() = 0;
  virtual bool IsWrite() = 0;
  virtual bool SgetMbusy() const = 0;

  // second request channel (data handshake)
  virtual void SreleaseData() = 0;
  virtual void SreleaseDataPE() = 0;
  virtual void SunreleaseDataPE() = 0; 
  virtual void SreleaseData(sc_time) = 0;
  virtual bool SgetDataRequest(bool) = 0;
  virtual bool SgetDataRequestBlocking(bool) = 0;
  virtual bool SgetDataRequestPE() = 0;

  // This event is triggered if an Mput or an Sput method is called
  // in the Channel connected to the Slave.
  virtual const sc_event& default_event() const = 0;

  // Access methods to the user defined data structures of the Channel.
  virtual TdataCl          *GetDataCl()  = 0;
  virtual ParamCl<TdataCl> *GetParamCl() = 0;
  virtual CommCl           *GetCommCl()  = 0;

  // Direct access method Slave to Master direction.
  virtual bool SputDirect(int, bool, Td*, Ta, int) = 0;
  virtual void SregisterDirectIF(SdirectIF<TdataCl>*) = 0;

  // Reset methods
  virtual void reset() = 0;
  virtual void remove_reset() = 0;
  virtual bool get_reset() = 0;

};

#endif // _TL_SLAVE_IF
