// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Norman Weyrich, Synopsys Inc.
//                Anssi Haverinen, Nokia Inc.
//         Date : 02/15/2003
//
//  Description : Transaction Level - Layer-1 example
//                Top level, asynchronous Master <---> asynchronous Slave,
//                datahandshake
//
// ============================================================================

#include "ocp_tl1_master_async_hs.h"
#include "ocp_tl1_slave_async_hs.h"
#include "ocp_tl1_data_cl.h"
#include "tl_channel.h"  


int sc_main(int, char*[])
{
  bool sync = true;
  TL_Channel<TL1_TEMPL_DATA_CL > ch0("ch0", sync);

  // Try reversing the next two declarations: Causes change in thread order.
  OCP_TL1_Master_Async_HS<TL1_TEMPL_DATA_CL > ms1("ms1", 1, 1, 20);
  OCP_TL1_Slave_Async_HS<TL1_TEMPL_DATA_CL > sl1("sl1", 1, 0x0, 0x3FF);

  sc_clock clk("clock", TL_CLK_PERIOD, TL_TIME_UNIT);

  ms1.MasterP(ch0);
  ms1.clk(clk);

  sl1.SlaveP(ch0);
  sl1.clk(clk);

  sc_start(500, SC_NS);

  return(0);
}
