// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapters
//      Author  : Herve Alexanian, Sonics Inc.
//
//  Description : definitions for ocp1.0. The ocp global definitions
//                included with the channels have ocp2.0 semantics.
//                For use with tl1/tl0 layer adapter
//  $Id: ocp_compatibility.h,v 1.1 2005/11/18 15:39:13 halexan Exp $ 
//
// ============================================================================
#ifndef _OCP_TL0_TL1_COMPATIBILITY_H
#define _OCP_TL0_TL1_COMPATIBILITY_H

#include "ocp_globals.h"

namespace Ocp1_0 {

enum OCPMBurstType {
    OCP_MBURST_LAST  = 0,
    OCP_MBURST_DFLT1 = 1,
    OCP_MBURST_TWO   = 2,
    OCP_MBURST_DFLT2 = 3,
    OCP_MBURST_FOUR  = 4,
    OCP_MBURST_STRM  = 5,
    OCP_MBURST_EIGHT = 6,
    OCP_MBURST_CONT  = 7
};

template<typename Td, typename Ta>
OCPMBurstType convertOcp2Burst( const OCPRequestGrp<Td, Ta>& request, unsigned int xferCount)
{
    unsigned int lengthLeft; 
    if (request.MBurstPrecise) {
        // Need to calculate the remaining burst length
        lengthLeft = request.MBurstLength + 1 - xferCount;
    } else {
        lengthLeft = request.MBurstLength;
    }
        
    if ( request.MCmd == OCP_MCMD_IDLE )
        return OCP_MBURST_LAST;
    if ( lengthLeft <= 1 ) {
        return OCP_MBURST_LAST;
    }
    switch ( request.MBurstSeq ) {
    case OCP_MBURSTSEQ_INCR:
        if (lengthLeft >= 8) return OCP_MBURST_EIGHT;
        if (lengthLeft >= 4) return OCP_MBURST_FOUR;
        if (lengthLeft >= 2) return OCP_MBURST_TWO;
        break;
    case OCP_MBURSTSEQ_STRM:
        return OCP_MBURST_STRM;
    case OCP_MBURSTSEQ_DFLT1:
        return OCP_MBURST_DFLT1;
    case OCP_MBURSTSEQ_DFLT2:
        return OCP_MBURST_DFLT2;
    case OCP_MBURSTSEQ_UNKN:
        // Really an error
        return OCP_MBURST_LAST;
    case OCP_MBURSTSEQ_WRAP:
        // Really an error
        return OCP_MBURST_LAST;
    case OCP_MBURSTSEQ_XOR:
        // Really an error
        return OCP_MBURST_LAST;
    default:
        break;
    }
    // This is really an error
    return OCP_MBURST_LAST;
}

template<typename Td, typename Ta>
void convertOcp1Burst( OCPRequestGrp<Td, Ta>& request,
                       OCPMBurstType ocp1Burst,
                       OCPMBurstSeqType lastType = OCP_MBURSTSEQ_INCR) 
{
    OCPMBurstSeqType ocp2Seq = OCP_MBURSTSEQ_INCR;
    int              ocp2Length = 1;
    // MBurstLength set according to Table 14 on page 32
    // of OCP Reference release 1.0 Sonics Extensions 2.4
    switch ( ocp1Burst ) {
    case OCP_MBURST_LAST:
        ocp2Length = 1; ocp2Seq = lastType;  break;
    case OCP_MBURST_DFLT1:
        ocp2Length = 2; ocp2Seq = OCP_MBURSTSEQ_DFLT1; break;
    case OCP_MBURST_TWO:
        ocp2Length = 2; ocp2Seq = OCP_MBURSTSEQ_INCR;  break;
    case OCP_MBURST_DFLT2:
        ocp2Length = 2; ocp2Seq = OCP_MBURSTSEQ_DFLT2; break;
    case OCP_MBURST_FOUR:
        ocp2Length = 4; ocp2Seq = OCP_MBURSTSEQ_INCR;  break;
    case OCP_MBURST_STRM:
        ocp2Length = 2; ocp2Seq = OCP_MBURSTSEQ_STRM;  break;
    case OCP_MBURST_EIGHT:
        ocp2Length = 8; ocp2Seq = OCP_MBURSTSEQ_INCR;  break;
    case OCP_MBURST_CONT:
        ocp2Length = 2; ocp2Seq = OCP_MBURSTSEQ_INCR;  break;
    }
    request.MBurstPrecise = 0;
    request.MBurstLength  = ocp2Length;
    request.MBurstSeq     = ocp2Seq;
}

}

#endif // _OCP_TL0_TL1_COMPATIBILITY_H
