// 
//  Copyright 2006 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//      Authors : Anssi Haverinen, Nokia
//                Herve Alexanian, Sonics
//         $Id: CPUMaster.h,v 1.1 2006/01/30 22:12:12 halexan Exp $
//
//  Description:  TL0-TL1 adapter demo
//                
// ============================================================================


#ifndef _CPU_MASTER_H
#define _CPU_MASTER_H

#include "channel_types.h"
#include "sim_params.h"

#include <map>
#include <string>

#include <systemc.h>
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_data_cl.h"
#include "ocp_tl1_channel.h"

#include "tl1_CPUMaster.h"
#include "read_map.h"


#include "ocp_tl0_port.h"
#include "ocp2_tl0_tl1_slave_adapter.h"
#include "ocp_tl1_slave_port.h"

// ----------------------------------------------------------------------------
//
//  Instantiation of the slave adapter template
//
// ----------------------------------------------------------------------------
template class OCP2_TL0_TL1_Slave_Adapter < OCP_TL1_DataCl<DType, AType >  >;


class master_tp_ports : public OCP2_TL0_MasterPorts {

public:

  // sc_port definitions

  sc_proxy_out_signal_port<sc_bv<3> > MCmd;
  sc_proxy_out_signal_port<sc_bv<A1Size> > MAddr;
  sc_proxy_out_signal_port <sc_bv<D1Size> > MData;
  sc_proxy_out_signal_port <sc_bv<D1Size/8> > MByteEn;
  sc_proxy_out_signal_port <bool> MRespAccept;
  sc_proxy_in_signal_port <bool> SCmdAccept;
  sc_proxy_in_signal_port <sc_bv<2> > SResp;
  sc_proxy_in_signal_port <sc_bv<D1Size> >SData;

  // default constructor, names all ports
  master_tp_ports():
    MCmd( "MCmd" ),
    MAddr( "MAddr" ),
    MData( "MData" ),
    MByteEn( "MByteEn" ),
    MRespAccept ( "MRespAccept" ),
    SCmdAccept ( "SCmdAccept" ),
    SResp( "SResp" ),
    SData( "SData" )
  {}


  virtual ~master_tp_ports() {}

  // bind ports to base interface class members
  void bind()
  {
    mapPort( MCmd, OCP2_TL0_MasterPorts::MCmd );
    mapPort( MAddr , OCP2_TL0_MasterPorts::MAddr );
    mapPort( MData , OCP2_TL0_MasterPorts::MData );
    mapPort( MByteEn , OCP2_TL0_MasterPorts::MByteEn );
    mapPort( MRespAccept , OCP2_TL0_MasterPorts::MRespAccept );
    mapPort( SCmdAccept , OCP2_TL0_MasterPorts::SCmdAccept );
    mapPort( SResp , OCP2_TL0_MasterPorts::SResp );
    mapPort( SData , OCP2_TL0_MasterPorts::SData );

  }
};



SC_MODULE(CPUMaster)
{

  sc_out<sc_bv<3> > MCmd;
  sc_out<sc_bv<A1Size> > MAddr;
  sc_out<sc_bv<D1Size> > MData;
  sc_out<sc_bv<D1Size/8> > MByteEn;
  sc_out<bool> MRespAccept;
  sc_in<bool> SCmdAccept;
  sc_in<sc_bv<2> > SResp;
  sc_in<sc_bv<D1Size> > SData;
  sc_in_clk Clk;

  tl1_CPUMaster  *mast1;
  OCP_TL1_Channel<OCP_TL1_DataCl< DType, AType > > *ocp0;
  OCP2_TL0_TL1_Slave_Adapter< OCP_TL1_DataCl<DType, AType > > * tp_tl0tl1;



  sc_signal<bool> tp_Clk;
  sc_signal< sc_bv< 3 > > tp_MCmd;
  sc_signal<sc_bv<A1Size> > tp_MAddr;
  sc_signal<sc_bv<D1Size> > tp_MData;
  sc_signal<sc_bv<D1Size/8> > tp_MByteEn;
  sc_signal<bool> tp_MRespAccept;
  sc_signal<bool> tp_SCmdAccept;
  sc_signal<sc_bv<2> > tp_SResp;
  sc_signal<sc_bv<D1Size> > tp_SData;

  
  CPUMaster ( sc_module_name name ) :
    sc_module( name ){



    MapStringType   ocpParamMap;
    string  ocpParamFileName = "ocpParams";
    
    if ( ! ocpParamFileName.empty() ) {
      readMapFromFile(ocpParamFileName, ocpParamMap);
    }
    ocp0 = new OCP_TL1_Channel<OCP_TL1_DataCl<DType, AType > > ((std::string)"ocp0", (sc_in_clk *) &Clk );
    ocp0->setConfiguration(ocpParamMap);
       
    mast1 = new tl1_CPUMaster("mast1");

    tp_tl0tl1 = new OCP2_TL0_TL1_Slave_Adapter< OCP_TL1_DataCl<DType, AType > > ( "tp_tl0tl1", OCP2_TL0_MasterPorts::Factory< master_tp_ports >());

    // port binding
    master_tp_ports& tp_tl0 = dynamic_cast<master_tp_ports&>( tp_tl0tl1->m_tl0Ports );
    

    tp_tl0tl1->SlaveP( *ocp0 ); 
    tp_tl0tl1->Clk(Clk ); 
    tp_tl0.MCmd( MCmd );
    tp_tl0.MAddr( MAddr );
    tp_tl0.MData ( MData );
    tp_tl0.MByteEn( MByteEn );
    tp_tl0.MRespAccept( MRespAccept );
    tp_tl0.SCmdAccept( SCmdAccept );
    tp_tl0.SResp( SResp );
    tp_tl0.SData( SData ); 
      
      
    mast1->tpP(*ocp0);
    mast1->Clk(Clk); 
    
    
  }

    void end_of_elaboration() { 
      // configure channels and adapters 
      tp_tl0tl1->setClockPeriod(sc_time( 10, SC_NS ) );
    } 
  

};


#endif
