///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  This file contains the PEQ used for the PEQed nb_transport
//                 calls. Since it is based on the OSCI peq_with_cb_and_phase
//                 we cannot make it copyright OCP, right?
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef OCPIP_VERSION
  #error ocp_peq.h may not be included directly. Use #inculde "ocpip.h" or #include "ocpip_X_X_X.h" (where desired ocp version is X.X.X)
#endif


namespace OCPIP_VERSION{

struct ocp_p2p_data{
  tlm::tlm_phase phase;
  unsigned int   address;
  unsigned int   burst_length;
  tlm::tlm_response_status response;
  bool           has_blen;//, has_req_info, has_dt_info, has_resp_info;
  unsigned int   index;
  //todo: valid data?
};

struct ocp_peq_traits{
  typedef tlm::tlm_generic_payload tlm_payload_type;
  typedef ocp_p2p_data tlm_phase_type;
};

template <typename SOCKET, bool TAGGED>
struct ocp_peq : public tlm_utils::peq_with_cb_and_phase<ocp_peq<SOCKET,TAGGED>, ocp_peq_traits>{

  template <typename MODULE>
  ocp_peq(MODULE* mod, typename nb_cb_type_selector<MODULE, TAGGED>::peq_cb_type, SOCKET* ext_support);
  
  void notify(ocp_peq_traits::tlm_payload_type& trans, tlm::tlm_phase& phase);
  
  void notify(ocp_peq_traits::tlm_payload_type& trans, tlm::tlm_phase& phase, const sc_core::sc_time& time);

  void notify(unsigned int, ocp_peq_traits::tlm_payload_type& trans, tlm::tlm_phase& phase);
  
  void notify(unsigned int, ocp_peq_traits::tlm_payload_type& trans, tlm::tlm_phase& phase, const sc_core::sc_time& time);
  
  void activate_dp();
protected:
  void peq_cb(ocp_peq_traits::tlm_payload_type& trans, const ocp_peq_traits::tlm_phase_type& p2p);
  ocp_p2p_data p2p_tmp;
  SOCKET* m_ext_support;
  sc_core::sc_time m_delta_cylce_protection;
  typename nb_functor_type_selector<TAGGED>::peq_functor_type m_functor;
  bool m_use_dp;
};

} //end ns OCPIP_VERSION

#include __MACRO_STRINGYFY__(../src/OCPIP_VERSION/ocp_peq.tpp)
