// 
//  (c) Copyright OCP-IP 2005
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Architectural Transaction Level Modeling
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : declaration of simple OCP TL3 master,
//
// ============================================================================

#ifndef _OCP_TL3_MASTER_H
#define _OCP_TL3_MASTER_H

#include "ocpip.h"
//#define OCP_TL3_MASTER_USE_PEQ

class ocp_tl3_master 
  : public sc_core::sc_module
{
public:
  // this module has SC processes
  SC_HAS_PROCESS(ocp_tl3_master);
  
  // OCP-specific TL3 specialized master port 
  //OCP_TL3_MasterPort<requestType,responseType> ocp;
  ocpip::ocp_master_socket_tl3<> ocp;

  ocp_tl3_master(sc_core::sc_module_name mod);
  ~ocp_tl3_master();

private:
  void send_request_method();
  
  //void get_response_method();
  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload&, tlm::tlm_phase&, sc_core::sc_time&);
  int m_sptr_req_gap;
  int m_sptr_resp_accept;
  sc_dt::uint64 m_sptr_address;
  unsigned int m_sptr_data;
  bool m_sptr_is_read;
  tlm::tlm_generic_payload* m_req;
  tlm::tlm_phase m_ph;
  sc_core::sc_time m_one_ns, m_time;
  sc_core::sc_event m_next_req;
#ifdef OCP_TL3_MASTER_USE_PEQ  
  sc_core::sc_event m_resp_event;
  void acc_response_method();
  tlm::tlm_generic_payload* m_resp;
#endif
  int m_count_sent;
  int m_count_received;
};


#endif // _OCP_TL3_MASTER_H
