// 
//  Copyright 2005 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author :Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : TL3 simple example system 
//		  using delayed interfaces with implicit timing annotation
//
// ============================================================================


#include "ocp_tl3_master.h"
#include "ocp_tl3_slave.h"

ocpip::map_string_type get_config_map(){
  ocpip::map_string_type config_map;

  config_map["broadcast_enable"]="i:0";
  config_map["burst_aligned"]="i:0";
  config_map["burstseq_dflt1_enable"]="i:0";
  config_map["burstseq_dflt2_enable"]="i:0";
  config_map["burstseq_incr_enable"]="i:0";
  config_map["burstseq_strm_enable"]="i:0";
  config_map["burstseq_unkn_enable"]="i:0";
  config_map["burstseq_wrap_enable"]="i:0";
  config_map["burstseq_xor_enable"]="i:0";
  config_map["burstseq_blck_enable"]="i:0";
  config_map["endian"]="i:1";
  config_map["force_aligned"]="i:0";
  config_map["mthreadbusy_exact"]="i:0";
  config_map["rdlwrc_enable"]="i:0";            
  config_map["read_enable"]="i:1";
  config_map["readex_enable"]="i:0";
  config_map["sdatathreadbusy_exact"]="i:0";
  config_map["sthreadbusy_exact"]="i:0";
  config_map["write_enable"]="i:1";
  config_map["writenonpost_enable"]="i:0";
  config_map["datahandshake"]="i:0";
  config_map["reqdata_together"]="i:0";
  config_map["writeresp_enable"]="i:0";
  config_map["addr"]="i:1";
  config_map["addr_wdth"]="i:64";
  config_map["addrspace"]="i:0";
  config_map["addrspace_wdth"]="i:1";
  config_map["atomiclength"]="i:0";
  config_map["atomiclength_wdth"]="i:1";
  config_map["burstlength"]="i:0";
  config_map["burstlength_wdth"]="i:0";
  config_map["blockheight"]="i:0";
  config_map["blockheight_wdth"]="i:1";
  config_map["blockstride"]="i:0";
  config_map["blockstride_wdth"]="i:1";
  config_map["burstprecise"]="i:0";
  config_map["burstseq"]="i:0";
  config_map["burstsinglereq"]="i:0";
  config_map["byteen"]="i:0";
  config_map["cmdaccept"]="i:1";
  config_map["connid"]="i:0";
  config_map["connid_wdth"]="i:1";
  config_map["dataaccept"]="i:0";
  config_map["datalast"]="i:0";
  config_map["datarowlast"]="i:0";
  config_map["data_wdth"]="i:32";
  config_map["mdata"]="i:1";
  config_map["mdatabyteen"]="i:0";
  config_map["mdatainfo"]="i:0";
  config_map["mdatainfo_wdth"]="i:1";
  config_map["mdatainfobyte_wdth"]="i:1";
  config_map["sdatathreadbusy"]="i:0";
  config_map["mthreadbusy"]="i:0";
  config_map["reqinfo"]="i:0";
  config_map["reqinfo_wdth"]="i:1";
  config_map["reqlast"]="i:0";
  config_map["reqrowlast"]="i:0";
  config_map["resp"]="i:1";
  config_map["respaccept"]="i:1";
  config_map["respinfo"]="i:0";
  config_map["respinfo_wdth"]="i:1";
  config_map["resplast"]="i:0";
  config_map["resprowlast"]="i:0";
  config_map["sdata"]="i:1";
  config_map["sdatainfo"]="i:0";
  config_map["sdatainfo_wdth"]="i:1";
  config_map["sdatainfobyte_wdth"]="i:1";
  config_map["sthreadbusy"]="i:0";
  config_map["threads"]="i:1";
  config_map["tags"]="i:1";
  config_map["taginorder"]="i:0";
  config_map["control"]="i:0";
  config_map["controlbusy"]="i:0";
  config_map["control_wdth"]="i:1";
  config_map["controlwr"]="i:0";
  config_map["interrupt"]="i:0";
  config_map["merror"]="i:0";
  config_map["mflag"]="i:0";
  config_map["mflag_wdth"]="i:1";
  config_map["mreset"]="i:0";
  config_map["serror"]="i:0";
  config_map["sflag"]="i:0";
  config_map["sflag_wdth"]="i:1";
  config_map["sreset"]="i:0";
  config_map["status"]="i:0";
  config_map["statusbusy"]="i:0";
  config_map["statusrd"]="i:0";
  config_map["status_wdth"]="i:1";
  config_map["sthreadbusy_pipelined"]="i:0";
  config_map["mthreadbusy_pipelined"]="i:0";
  config_map["sdatathreadbusy_pipelined"]="i:0";
  return config_map;
}


int sc_main(int, char*[])
{


  int end_time = 50000;

 

  // Creates masters and slaves 
  ocp_tl3_slave  sl1("sl1");
  ocp_tl3_master ms1("ms1");

  //configure the sockets
  ocpip::ocp_parameters  config;
  ocpip::map_string_type config_map=get_config_map();
  config.set_ocp_configuration(sl1.ocp.name(), config_map);
  sl1.ocp.set_ocp_config(config);
  config.set_ocp_configuration(ms1.ocp.name(), config_map);
  ms1.ocp.set_ocp_config(config);
 
  // Connect masters and slaves using channels
#ifdef USE_OCP_MONITOR
  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece1(ms1.ocp, sl1.ocp);
  ocpip::ocp_tl3_imc_logger ocp_tl3_imc_logger(ocp_monitor_t_piece1, "tl3_log.txt", 1, 4, 4, true);
#else
  ms1.ocp(sl1.ocp);
#endif
  static float fSimulationCPUTime = 0;
  clock();

  // start simulation 
  sc_start(100, sc_core::SC_NS);

  fSimulationCPUTime = (float)( (float)clock() / (float)CLOCKS_PER_SEC );
  cerr << "SystemC simulated duration: " << sc_time_stamp() << endl;
  cerr << "                  CPU time: " << fSimulationCPUTime <<  endl;

  return (0);
};
