// 
//  Copyright 2008 OCP-IP
//  OCP-IP Confidential and Proprietary
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: main.cc,v 1.5 2006/02/25 03:01:05 Anssi Exp $
//
//  Description : OCP API -  TL1 AMBD profile example
//
// ============================================================================
 
// Turn on user messages
//#define DEBUG_G1

// Turn off OCP protocol checker, if installed
//#define NDEBUG

// Include SystemC
#include "systemc"

// Include user-defined headers
#include "ocpip.h"
#include "command_line.h"
// Include submodules
#include "master.h"
#include "slave.h"

int sc_main(int argc, char* argv[]) {

  // OCP parameters
  ocpip::map_string_type  ocpParamMap;
  std::string ocpParamFileName;

  sc_core::sc_clock clk;

  // Read command line parameters
  process_command_line(argc,argv,ocpParamFileName);

  // Read OCP parameters from file
  if ( ! ocpParamFileName.empty() ) {
    readMapFromFile(ocpParamFileName, ocpParamMap);
  }
  
  
  
  // Submodules
  Slave sl1("sl1");
  Master ms1("ms1");

  // Set OCP configuration
  ocpip::ocp_parameters params;
  params.set_ocp_configuration("sl1", ocpParamMap);
  sl1.ipP.set_ocp_config(params);

  params.set_ocp_configuration("ms1", ocpParamMap);
  ms1.ipP.set_ocp_config(params);

  // netlist
  //ch0.p_clk(clk);
  
#ifdef USE_OCP_MONITOR  
  ocpip::ocp_connection_monitor<32> ocp_monitor_t_piece(ms1.ipP, sl1.ipP);
  ocpip::ocp_tl1_monitor_adapter<32,32> mon_adapt(ocp_monitor_t_piece);
#else
  ms1.ipP(sl1.ipP);
#endif
  ms1.clk(clk);
  sl1.clk(clk);

#ifdef USE_OCP_MONITOR
  // transaction recording monitor
  typedef ocpip::ocp_tl1_monitor_adapter<32,32>::data_class_type data_class_type;
  scv_tr_text_init();
  scv_tr_db db("ocp_db");
  scv_tr_db::set_default_db(&db);
  bool ChannelRecording = true;
  bool SystemRecording = false;
  typedef ocpip_legacy::OCP_Tl1_Perf_Monitor<data_class_type> perf_monitor_type;
  ocpip_legacy::OCP_TL1_Trace_Monitor_Clocked<data_class_type> tracer("Tracer", "ocp0.ocp");
  tracer.p_mon(mon_adapt);
  tracer.p_clk(clk);
  perf_monitor_type pmon0("pmon0",ChannelRecording,SystemRecording);
  pmon0.p_mon(mon_adapt);
  pmon0.p_clk(clk);

#endif

  // Simulator
  sc_core::sc_start(70, sc_core::SC_NS);
  
  return(0);
}
