///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :  This file contains a wrapper around a deque. It limits the
//                 interface to the deque and therefore allows to change 
//                 the underlying deque to something else (if needed).
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __FIFO_H__
#define __FIFO_H__

#include <deque>
#include "tlm.h"

template <typename T>
class fifo{
public:
  void push_back(const T& val){ m_deque.push_back(val);}
  T&   front() { return m_deque.front();}
  T&   back() { return m_deque.back();}
  void pop_front() {m_deque.pop_front();}
  unsigned int size() {return m_deque.size();}
private:
  std::deque<T> m_deque;
};

#endif

