///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2008
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//
//          $Id:
//
//  Description :
//                                                                           //
///////////////////////////////////////////////////////////////////////////////

#ifndef __deep_copier_h__
#define __deep_copier_h__

#include "ocpip.h"

template<unsigned int BUSWIDTH>
class deep_copier : 
  public sc_core::sc_module
{
  struct txn_per_copier : public ocpip::infr::ocp_data_only_extension<txn_per_copier>
  {
    std::vector<tlm::tlm_generic_payload*> txns;
  
    void copy_from(tlm::tlm_extension_base const & ext){}
    
    tlm::tlm_extension_base* clone() const {return NULL;}
    
    std::string dump() const{ return "not dumpable";}
  };
  
  struct reset_me_when_your_done : public tlm::tlm_extension<reset_me_when_your_done>
  {
    void copy_from(tlm::tlm_extension_base const & ext){}
    
    void free(){
      if (get_do_free()){
        me->reset();
      }
    }
    
    tlm::tlm_extension_base* clone() const {return NULL;}
    
    tlm::tlm_generic_payload* me;
    
    static bool& get_do_free(){
      static bool do_free=true;
      return do_free;
    }

  };

  
  public:
  // ports
  ocpip::ocp_slave_socket_tl1<BUSWIDTH> ocps;
  ocpip::ocp_master_socket_tl1<BUSWIDTH> ocpm;
  
  deep_copier(sc_core::sc_module_name name)
    : sc_core::sc_module(name)
    , ocps("ocps", this, &deep_copier::setOCPTL1MasterTiming)
    , ocpm("ocpm", this, &deep_copier::setOCPTL1SlaveTiming, ocpip::ocp_master_socket_tl1<BUSWIDTH>::mm_txn_with_be_and_data())
    , m_id(inst_cnt++)
  {
    ocpm.register_nb_transport_bw(this, &deep_copier::nb_transport_bw, false); //no peq
    ocps.register_nb_transport_fw(this, &deep_copier::nb_transport_fw, false); //no peq
    ocpm.register_configuration_listener_callback(this, &deep_copier::ocpm_config_cb);
    ocps.register_configuration_listener_callback(this, &deep_copier::ocps_config_cb);
    ocpm.make_generic();
    ocps.make_generic();
  };

  ~deep_copier() {
    //deactivate the free method of the extension, because during destruction
    // it might be called twice: once when the deep copy dies (when the deep copier's socket dies)
    // and once when an outstanding original txn dies
    //  then we would end up resetting a txn twice (and at the second time it might even have already been
    //  deallocated).
    reset_me_when_your_done::get_do_free()=false;
  }

  void ocps_config_cb(const ocpip::ocp_parameters& conf, const std::string& name)
  {
    std::cout<<"Got config from "<<name<<std::endl
             <<" forward to other socket"<<std::endl;
    ocpm.set_ocp_config(conf);
  }
  
  void ocpm_config_cb(const ocpip::ocp_parameters& conf, const std::string& name){
    std::cout<<"Got config from "<<name<<std::endl
             <<" forward to other socket"<<std::endl;
    ocps.set_ocp_config(conf);
  }
    
  void setOCPTL1SlaveTiming(ocpip::ocp_tl1_slave_timing slave_timing) {
    std::cout << "  << S-S-T >>   " << name() << std::endl;
    ocps.set_slave_timing(slave_timing);
  }

  void setOCPTL1MasterTiming(ocpip::ocp_tl1_master_timing master_timing) {
    std::cout << "  << S-M-T >>   " << name() << std::endl;
    ocpm.set_master_timing(master_timing);
  }


  tlm::tlm_sync_enum nb_transport_bw(tlm::tlm_generic_payload& gp2, tlm::tlm_phase& ph, sc_core::sc_time& tim){
    //this can only be a thread busy update, a reqAccept, a dataAccept or a startResp
  
    //since the deep copier does not detect the end of txn
    // it can only work if no one down stream acquired the txn
    //  but that is okay because it won't happen in our tests
    assert(gp2.get_ref_count()<2);

    txn_per_copier* txn_ext=ocps.template get_extension<txn_per_copier>(gp2);
    if (txn_ext->txns.size()<inst_cnt) txn_ext->txns.resize(inst_cnt, NULL);
    if (!txn_ext->txns[m_id]) {
      //the only point where a bw txn could not have a original txn associated is with thread busy
      txn_ext->txns[m_id]=ocpm.get_transaction();
      ocpm.reserve_data_size(*txn_ext->txns[m_id], gp2.get_data_length());
      ocpm.reserve_be_size(*txn_ext->txns[m_id], gp2.get_byte_enable_length());      
      txn_ext->txns[m_id]->deep_copy_from(gp2);
    }

    tlm::tlm_generic_payload& gp=*txn_ext->txns[m_id];
    
    gp.update_extensions_from(gp2);
    assert(gp.get_data_length()==gp2.get_data_length());
    assert(gp.get_command()==gp2.get_command());
    
    if (gp.is_read()){
      //manually copy back the read data from deep copy to original
      for (unsigned int i=0; i<gp.get_data_length(); i++)
        gp.get_data_ptr()[i]=gp2.get_data_ptr()[i];
    }
    
    //copy resp from copy to orig
    gp.set_response_status(gp2.get_response_status());

    //as already mentioned this can only be a thread busy update, a reqAccept, a dataAccept or a startResp
    // the first must be accepted and there won't be any change to the txn
    // the same applies to the second and third
    // the last can be updated but there cannot be a change in the txn
    // in summary: we do not need to update the copy after calling nb_bw with the orig
    return ocps->nb_transport_bw(gp, ph, tim);
  }


  tlm::tlm_sync_enum nb_transport_fw(tlm::tlm_generic_payload& gp, tlm::tlm_phase& ph, sc_core::sc_time& tim){
    txn_per_copier* txn_ext=ocps.template get_extension<txn_per_copier>(gp);
    if (txn_ext->txns.size()<inst_cnt) txn_ext->txns.resize(inst_cnt, NULL);
    if (!txn_ext->txns[m_id]) {
      txn_ext->txns[m_id]=ocpm.get_transaction();
      reset_me_when_your_done* reseter=new reset_me_when_your_done(); //we accept the mem leak here. The deep copier is only meant for small tests
      reseter->me=txn_ext->txns[m_id];
      txn_ext->txns[m_id]->set_extension(reseter); //add sticky to deep copy
    }
    
    tlm::tlm_generic_payload& gp2=*txn_ext->txns[m_id];
    
    gp.set_auto_extension(gp2.get_extension<reset_me_when_your_done>()); //original resets deep copy when it's done
    
    //remember the original txn associated to this deep copy
    if (ocps.template get_extension<txn_per_copier>(gp2)->txns.size()<inst_cnt) ocps.template get_extension<txn_per_copier>(gp2)->txns.resize(inst_cnt);
    ocps.template get_extension<txn_per_copier>(gp2)->txns[m_id]=&gp;
    
    //since the deep copier does not detect the end of txn
    // it can only work if no one down stream acquired the txn
    //  but that is okay because it won't happen in our tests
    assert(gp2.get_ref_count()<2);
    
    ocpm.reserve_data_size(gp2, gp.get_data_length());
    ocpm.reserve_be_size(gp2, gp.get_byte_enable_length());
    
    gp2.deep_copy_from(gp);
      
    tlm::tlm_sync_enum retVal=ocpm->nb_transport_fw(gp2, ph, tim);
    
    //here we have to update the exts after the call
    // since the slave could have changed the bool within the semaphore extension
    gp.update_extensions_from(gp2);
    return retVal;
  }
  
  static unsigned int inst_cnt;
  unsigned int m_id;
};

template<unsigned int BUSWIDTH>
unsigned int deep_copier<BUSWIDTH>::inst_cnt=0;


// end of multiple inclusion protection
#endif

