//////////////////////////////////////////////////////////////////////
//
// Copyright (c) 2003-2005 Sonics, Inc.
//
// Confidential and Proprietary Information of Sonics, Inc.
// Use, disclosure, or reproduction is prohibited without
// written permission from Sonics, Inc.
//
// $Id: Memory.h,v 1.1 2007/01/25 22:09:07 halexan Exp $            
//
// Description: Memory Management macros
//////////////////////////////////////////////////////////////////////

#ifndef _Memory_h
#define _Memory_h

#ifdef NDEBUG
#define POINTER_CHECK(p)
#else
// should be aligned for double
#define POINTER_CHECK(p) assert(!(0x7 & ((long)(p))))
#endif

// aviod confusing Coverity's Prevent tool
#ifdef COVERITY
#define NO_MEM_CHECK
#endif

#ifdef NO_MEM_CHECK

#define DELETE(x)         delete(x)
#define DELETE_ARRAY(x)   delete[](x)

#define ASSERT_DELETE(x)  delete(x)

#else

// Avoid multiple frees and recursion with destructors
#define DELETE(x)         {if (x) { POINTER_CHECK(x); typeof(x) t(x) ; x = 0 ; delete(t)  ;}}
#define DELETE_ARRAY(x)   {if (x) { POINTER_CHECK(x); typeof(x) t(x) ; x = 0 ; delete[](t);}}

#define ASSERT_DELETE(x)  {assert(x); POINTER_CHECK(x); typeof(x) t(x) ; x = 0 ; delete(t) ;}

#endif

#endif
