// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master_r.h,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP - TL1 profile example
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_R_H
#define _OCP_TL1_MASTER_R_H

// Turn on debug messages
#define DEBUG_G1

#include <iostream>
#include "stdlib.h"

// User defined types

#include "fifo.h"

// OCP-IP Channel header files
#include "ocpip.h"

class Master_r : public sc_core::sc_module
{  

  struct expected_rsp{
    expected_rsp(tlm::tlm_generic_payload* txn_, unsigned int chunk_, bool last_)
      : txn(txn_)
      , chunk(chunk_)
      , last(last_){}
    tlm::tlm_generic_payload* txn;
    unsigned int chunk;
    bool last;
  };

public:  
  
  typedef ocpip::ocp_data_class_unsigned<32,32>::DataType Td;
  typedef ocpip::ocp_data_class_unsigned<32,32>::AddrType Ta;

  // channel port
  ocpip::ocp_master_socket_tl1<32> ipP;

  // TL1 clock
  sc_core::sc_in_clk  clk;

  SC_HAS_PROCESS(Master_r);

  // constructor
  Master_r(sc_core::sc_module_name name_);

  // destructor
  ~Master_r();

  tlm::tlm_sync_enum nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim);

  // threads
  void proc();

  int cnt, burstcnt;
  int wraplen;
  Ta addr;

  // Request group
  tlm::tlm_generic_payload* req;
  bool ongoing_req;
  tlm::tlm_generic_payload* resp;

  fifo<expected_rsp>    expected_rsps;

  tlm::tlm_phase phase;
  sc_core::sc_time time;
  
  unsigned int rspcnt;

};


#endif // _OCP_TL1_MASTER_R_H
