///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP master model driven by STL
//                 stimulus for use in TL1 modeling examples. Uses TL3 model +
//                 TL3/TL1 (slave) adapter
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#ifndef __OCPIP_GENERIC_STL_MASTER_TL1_H__
#define __OCPIP_GENERIC_STL_MASTER_TL1_H__

#include "generic_stl_master_tl3.h"
#include "ocpip_adapters.h"

namespace ocpip_example {
template <unsigned int BUSWIDTH>
class generic_stl_master_tl1 : public sc_core::sc_module {
public:
    generic_stl_master_tl1( sc_core::sc_module_name );
    ocpip::ocp_master_socket_tl1<BUSWIDTH>     m_socket;
    sc_core::sc_in_clk                         m_clk;
    void set_period( sc_core::sc_time t ) {
	m_model.set_period( t );
    }
private:
    void propagate_config( const ocpip::ocp_parameters&, const std::string& );
    generic_stl_master_tl3<BUSWIDTH>            m_model;
    ocpip::ocp_tl1_tl3_slave_adapter<BUSWIDTH>  m_adapter;
};
}

#endif
