///////////////////////////////////////////////////////////////////////////////
//                                                                           //
// (c) Copyright OCP-IP 2009-2010
// OCP-IP Confidential and Proprietary
//
//
//============================================================================
//      Project : OCP SLD WG
//       Author : Herve Alexanian - Sonics, inc.
//
//          $Id:
//
//  Description :  This file defines a generic OCP slave model for use in TL1
//                 modeling examples
//
//                                                                           //
///////////////////////////////////////////////////////////////////////////////
#include "generic_mem_slave_tl1.h"

template<unsigned int BUSWIDTH>
ocpip_example::generic_mem_slave_tl1<BUSWIDTH>::generic_mem_slave_tl1( sc_core::sc_module_name nm ) :
    sc_core::sc_module( nm )
    , m_socket   ( "socket"    )
    , m_clk      ( "clk"       )
    , m_model    ( "mem_tl3"   )
    , m_adapter  ( "adapter"   )
{    
    m_adapter.tl1_socket.make_generic();
    this->m_socket( m_adapter.tl1_socket ); // hier binding
    m_socket.register_configuration_listener_callback(this, &generic_mem_slave_tl1<BUSWIDTH>::propagate_config);
    
    m_adapter.master_socket.make_generic();
    m_model.m_socket.make_generic();
    m_adapter.master_socket( m_model.m_socket );
    m_adapter.clk(m_clk);

    m_adapter.config.max_active_req        = 2;
    m_adapter.config.max_active_resp_data  = 8;
    m_adapter.config.max_active_write_data = 4;

    // TODO: make user level control for delays
#ifdef SCV_RANDOM_H
    m_adapter.set_delay_obj( tlm::BEGIN_RESP, ocpip::phase_delay_range_random_calc<uint32_t>( 0,1 ) );
    m_adapter.set_delay_obj( tlm::END_REQ,    ocpip::phase_delay_range_random_calc<uint32_t>( 0,1 ) );
    m_adapter.set_delay_obj( ocpip::END_DATA, ocpip::phase_delay_range_random_calc<uint32_t>( 0,2 ) );
#else
    m_adapter.set_delay_obj( tlm::BEGIN_RESP, ocpip::phase_delay_basic_burst_calc <uint32_t>( 0,0 ) );
    m_adapter.set_delay_obj( tlm::END_REQ,    ocpip::phase_delay_basic_burst_calc <uint32_t>( 1,0 ) );
    m_adapter.set_delay_obj( ocpip::END_DATA, ocpip::phase_delay_basic_burst_calc <uint32_t>( 2,1 ) );
#endif
}

template<unsigned int BUSWIDTH>
void
ocpip_example::generic_mem_slave_tl1<BUSWIDTH>::propagate_config( const ocpip::ocp_parameters& conf, const std::string& )
{
    m_adapter.master_socket.set_ocp_config( conf );
    m_model.m_socket.set_ocp_config( conf );
}
