// 
//  Copyright 2008 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//                Robert Guenzel (from TU of Braunschweig) for Greensocs Ltd.
//           $Id: master.cc,v 1.1 2005/01/07 03:42:33 Anssi Exp $
//
//  Description : OCP API - TL1 profile example
// ============================================================================

#include "master.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
Master::Master (sc_core::sc_module_name name_)
  : sc_core::sc_module (name_)
  , ipP("ipPort", ocpip::ocp_master_socket_tl1<32>::mm_txn_with_data())
  , req(NULL)
  , ongoing_req(false)
  , ongoing_dhs(false)
  , resp(NULL) 
{

  // initialize common members
  cnt = 0;
  addr = 0;
  read = false;
  burstcnt = 0;
  dhscnt = 0;
  srmd_cont = false;
  SC_METHOD(proc);
  sensitive<<clk.pos(); 
  dont_initialize();
  ipP.register_nb_transport_bw(this, &Master::nb_transport);
  ipP.activate_synchronization_protection();
}

// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
Master::~Master() {}



void Master::start_of_simulation(){
  ocpip::ocp_parameters params=ipP.get_resolved_ocp_config();
  writeresps=params.writeresp_enable;
}

// ----------------------------------------------------------------------------
//  Method : Master::proc()
//
//  Synchronous Master process
//
// ----------------------------------------------------------------------------
void Master::proc() {

  // check if request data channel is free
  if (!ongoing_dhs) {
    if (req_data.size() && req_data.front().currently_allowed_chunks>dhscnt){
      // Send data if request group has been already sent

      phase=ocpip::BEGIN_DATA;
      time=sc_core::SC_ZERO_TIME;
      tlm::tlm_sync_enum retVal=ipP->nb_transport_fw(*req_data.front().txn, phase, time);
#ifdef DEBUG_G1
      std::cout << "Master sent data "
	   << "  time  = " << sc_core::sc_time_stamp().to_seconds()
	   << "  MData  = " << (*(((Td*)(req_data.front().txn->get_data_ptr()))+dhscnt)) << std::endl;
#endif
      switch (retVal){
        case tlm::TLM_ACCEPTED: ongoing_dhs=true; break;
        case tlm::TLM_UPDATED:{
          if (phase!=ocpip::END_DATA){ //that's the only update allowed for BEGIN_DATA
            std::cerr<<"Error in "<<name()<<": Got updated phase "<<phase<<" in response to BEGIN_DATA"<<std::endl;
            exit(1);
          }
          if ((++dhscnt)==req_data.front().max_chunks) {
            if (!writeresps) {
              ipP.release_transaction(req_data.front().txn); //we are done with this txn, if there is no writeresp
            }
            req_data.pop_front();
            dhscnt=0;
          }
          break;
          //we can leave ongoing_dhs at false, as we can do a dhs at the next clock edge
        }
        case tlm::TLM_COMPLETED:;
      }
    }
  }

  // check if request channel is free
  if (!ongoing_req || srmd_cont) {
    if (cnt==0 | cnt==16) {
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, 8*sizeof(Td));
      req->set_command(tlm::TLM_WRITE_COMMAND);
      ipP.validate_extension<ocpip::posted>(*req);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::burst_length* b_len;
      ipP.get_extension<ocpip::burst_length>(b_len, *req);
      b_len->value=8;
      ipP.validate_extension<ocpip::burst_length>(*req);
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(8*sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
    }
    else
    if (cnt==8 | cnt==24) {
      req=ipP.get_transaction();
      ipP.reserve_data_size(*req, 8*sizeof(Td));
      req->set_command(tlm::TLM_READ_COMMAND);
      ocpip::burst_sequence* b_seq;
      ipP.get_extension<ocpip::burst_sequence>(b_seq, *req);
      b_seq->value.sequence=ocpip::INCR;
      ipP.validate_extension<ocpip::burst_sequence>(*req);
      ocpip::burst_length* b_len;
      ipP.get_extension<ocpip::burst_length>(b_len, *req);
      b_len->value=8;
      ipP.validate_extension<ocpip::burst_length>(*req);    
      req->set_byte_enable_ptr(NULL);
      req->set_streaming_width(8*sizeof(Td));
      req->set_response_status(tlm::TLM_INCOMPLETE_RESPONSE);
    }
    if (cnt==0 || cnt==8 || cnt==16 || cnt==24){
      if (req->get_command()==tlm::TLM_WRITE_COMMAND)
        req->set_address(addr);
      else
        req->set_address(addr & (~0x20));
    }
    if (cnt<25) {
      if (cnt<16 | cnt==16 | cnt==24) 
        phase=tlm::BEGIN_REQ;
      else
        phase=tlm::UNINITIALIZED_PHASE;
      //else phase=ocpip::BEGIN_SRMD_REQ;
      if (cnt==16 | cnt==24) ipP.validate_extension<ocpip::srmd>(*req);
      if (!read) {
        if (burstcnt==7) {
          burstcnt=0;
          read = true;
        }
        else {
          burstcnt++;
        }	
      }
      else {
        if (burstcnt==7) {
          burstcnt=0;
          read = false;
        }
        else {
          burstcnt++;
        }	
      }
    }
    else {
      phase=tlm::UNINITIALIZED_PHASE;
      burstcnt = 0;
    }
  
    //std::cout<<phase<<std::endl;
    // Send request
    if (((ipP.get_extension<ocpip::srmd>(*req)) && burstcnt==1) || (phase==tlm::BEGIN_REQ)) {
      if (ipP.get_extension<ocpip::srmd>(*req)) srmd_cont = true;
      if (phase!=tlm::UNINITIALIZED_PHASE) {
        time=sc_core::SC_ZERO_TIME;
        tlm::tlm_sync_enum retVal = ipP->nb_transport_fw(*req, phase, time);
        switch(retVal){
          case tlm::TLM_ACCEPTED: ongoing_req=true; break;
          case tlm::TLM_UPDATED: 
            switch (phase){
              case tlm::END_REQ: 
              /*
                if (srmd_cont) {
                  std::cerr<<"Error in "<<name()<<" : BEGIN_SRMD_REQ was updated with "<<phase<<std::endl;
                  exit(1);
                }
              */
                break;
              default:
                std::cerr<<"Error in "<<name()<<" : got unexpected phase update to "<<phase<<" in response to BEGIN_(SRMD_)REQ."<<std::endl;
                exit(1);                
            }
            break;
          case tlm::TLM_COMPLETED:;
        }

#ifdef DEBUG_G1
        std::cout << "Master sent request "
             << "  time  = " << sc_core::sc_time_stamp().to_seconds()
             << "  MAddr  = " << addr << std::endl;
#endif
	
        if (req->get_command() == tlm::TLM_WRITE_COMMAND) {
          *(((Td*)(req->get_data_ptr()))+(((burstcnt)?burstcnt:8)-1))=addr;
          if ((req_data.size()==0) ||req!=req_data.back().txn){
            assert(burstcnt==1);
            req_data.push_back(outstanding_dhs(req, 8, burstcnt, cnt>15));
          }
          else
            req_data.back().currently_allowed_chunks++;
          if (writeresps) expected_rsps.push_back(expected_rsp(req, (((burstcnt)?burstcnt:8)-1), (cnt>15)? true : burstcnt==0));
        }
        else { //read command
          if (cnt>15) {//srmd
            for (int i=0; i<8; i++)
              expected_rsps.push_back(expected_rsp(req, i, i==7));
          }
          else
            expected_rsps.push_back(expected_rsp(req, (((burstcnt)?burstcnt:8)-1), burstcnt==0));
        }
          
        if (addr < 124)
          addr += 4;
        else
          addr = 0;
	
        cnt++;
      }
    }
    else if (req->get_command() == tlm::TLM_WRITE_COMMAND) { // for SRMD data requests
      cnt++;
      *(((Td*)(req->get_data_ptr()))+(((burstcnt)?burstcnt:8)-1))=addr+((burstcnt)?burstcnt:8)-1;
      assert(req==req_data.back().txn);
      req_data.back().currently_allowed_chunks++;
      if (burstcnt==0) {
        srmd_cont = false;
      }
    }
  }
  
  
  if (resp) {
    time=sc_core::SC_ZERO_TIME;
    phase=tlm::END_RESP;
    ipP->nb_transport_fw(*resp, phase, time);
    assert(expected_rsps.front().txn==resp);
    if (resp->get_response_status() == tlm::TLM_OK_RESPONSE) {
#ifdef DEBUG_G1
      std::cout << "Master got valid response "
       << "  time  = " << sc_core::sc_time_stamp().to_seconds()
       << "  SResp  = " << resp->get_response_status()
       << "  SData  = " << (*(((Td*)(resp->get_data_ptr()))+expected_rsps.front().chunk)) << std::endl;
#endif
      if (expected_rsps.front().last) {
        ipP.release_transaction(resp); //we are done with this txn now
      }
      resp=NULL;
      expected_rsps.pop_front();
    }
  }
   
} // end of method

tlm::tlm_sync_enum Master::nb_transport(tlm::tlm_generic_payload& txn, tlm::tlm_phase& ph, sc_core::sc_time& tim) {
  switch(ph){
    case tlm::END_REQ:
      ongoing_req=false;
      break;
    case tlm::BEGIN_RESP: resp=&txn; break;
    default:
      if (ph==ocpip::END_DATA){
        ongoing_dhs=false;
        assert(req_data.size());
        if ((++dhscnt)==req_data.front().max_chunks) {
          if (!writeresps) {
            ipP.release_transaction(req_data.front().txn); //we are done with this txn, if there is no writeresp
          }
          req_data.pop_front();
          dhscnt=0;
        }
      }
      //else
      //if (ph==ocpip::END_SRMD_REQ)
      //  ongoing_req=false;
      else{
        std::cerr<<"Error in "<<name()<<" : got unexpected phase "<<ph<<" in nb_transport_bw"<<std::endl;
        exit(1);
      }
  }
  return tlm::TLM_ACCEPTED;
}


