// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//		 modified by: Stephane Guntz, Prosilog, guntz@prosilog.com
//					  Yann Bajot, Prosilog, bajot@prosilog.com
//
//  Description : Transaction Level - Layer-1 example Slave
//  $Id: ocp_tl1_slave_sync.h,v 1.1.1.1 2004/09/24 09:26:19 sguntz Exp $
//
// ============================================================================

#ifndef _OCP_TL1_SLAVE_SYNC_H
#define _OCP_TL1_SLAVE_SYNC_H

#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl1_data_cl.h"
#include "ocp_tl1_slave_port.h"

const sc_time_unit TL_TIME_UNIT  = SC_NS; 
const double       TL_CLK_PERIOD = 1;     // clock period
const int          TL_SLAVE_FIFO_DEPTH = 10;

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl> class OCP_TL1_Slave_Sync
  : public sc_module
  , public SdirectIF<TdataCl>
{
public:  

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  OCP_TL1_SlavePort< TdataCl> SlaveP;
  sc_in_clk clk;

  SC_HAS_PROCESS(OCP_TL1_Slave_Sync);

  // constructor
  OCP_TL1_Slave_Sync(sc_module_name name_
             , int ID
             , Ta StartAddress
             , Ta EndAddress
            );

  // destructor
  ~OCP_TL1_Slave_Sync();

  // methods
  virtual bool MputDirect(int, bool, Td*, Ta, int);
  void Request();
  void Response();

private :
  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;

  // parameters
  int m_ID;
  Ta m_StartAddress;
  Ta m_EndAddress;

  // constants
  int m_NumWordsPerBeat;
  int m_SmemoryLength;

  // data
  Td *m_SlaveMemory;
  Td response_data;
  int m_MThreadID;

  // request-response synchronization
  bool m_RespEventS[TL_SLAVE_FIFO_DEPTH];
  sc_event m_RespEvent;
};

#endif
