// 
//  (c) Copyright OCP-IP 2006
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Architectural Transaction Level Modeling
//       Author : Tim Kogel, CoWare Inc.
//         $Id: 
//
//  Description : implementation of simple OCP TL3 master,
//		  SCV based randomization of transactions and timing,
//		  uses implicit delay annotation of OCP_TL2_MasterIF
//
// ============================================================================

#ifndef _OCP_TL3_MASTER_CPP
#define _OCP_TL3_MASTER_CPP

#include "ocp_tl3_master.h"

template <class Td, class Ta>
ocp_tl3_master<Td,Ta>::ocp_tl3_master(sc_module_name mod):
  sc_module(mod), 
  ocp("OcpP"),
  m_count_sent(0),
  m_count_received(0)
{
  m_sptr_req_gap = 10;
  m_sptr_resp_accept = 5;
  m_sptr_address = 0;
  m_sptr_data = 0;
  m_sptr_is_read = true;

  // declare my sensitive methods
  SC_METHOD(send_request_method);
  sensitive << ocp.RequestEndEvent();

  SC_METHOD(get_response_method);
  sensitive << ocp.ResponseStartEvent();
  dont_initialize();
}

template <class Td, class Ta>
ocp_tl3_master<Td,Ta>::~ocp_tl3_master()
{
  cout << name() << " sent : " << m_count_sent 
       << ", received : " << m_count_received << endl;
}

template <class Td, class Ta>
void
ocp_tl3_master<Td,Ta>::end_of_elaboration()
{
}

template <class Td, class Ta>
void
ocp_tl3_master<Td,Ta>::send_request_method()
{
    m_sptr_req_gap = 10 + (m_sptr_req_gap+1)%10;
    m_sptr_is_read = !m_sptr_is_read;
    m_sptr_address = (m_sptr_address+77)%0x500;
    if (m_sptr_is_read) {
      m_req.type =  basic_protocol::READ;
    } else {
      m_req.type =  basic_protocol::WRITE;
      m_req.d = m_sptr_address;
    }
    m_req.a = m_sptr_address;
    ocp->sendRequest(m_req,m_sptr_req_gap);
    m_count_sent++;
#ifndef NDEBUG 
    cout << sc_time_stamp() << ", " << name() 
	 << ", is " << (m_req.type?"READ":"WRITE")
	 << " suspend for " << m_sptr_req_gap << " cycles\n";
#endif
}

template <class Td, class Ta>
void
ocp_tl3_master<Td,Ta>::get_response_method()
{
  if (!ocp->getResponse(m_resp)) {
    cerr << sc_time_stamp() << " get_response_method " << name() 
	 << " nothing to get\n";
    ocp->acceptResponse();
    return;
  }
  m_sptr_resp_accept = 5 + (m_sptr_resp_accept+1)%5;
  m_count_received++;
#ifndef NDEBUG 
  cout << sc_time_stamp() << " get_response_method " << name() 
       << " in " << m_sptr_resp_accept << " cycles\n";
#endif
  ocp->acceptResponse(m_sptr_resp_accept);
}


#endif // _OCP_TL3_MASTER_CPP
