/*****************************************************************************

  The following code is derived, directly or indirectly, from the SystemC
  source code Copyright (c) 1996-2003 by all Contributors.
  All Rights reserved.

  The contents of this file are subject to the restrictions and limitations
  set forth in the SystemC Open Source License Version 2.4 (the "License");
  You may not use this file except in compliance with such restrictions and
  limitations. You may obtain instructions on how to receive a copy of the
  License at http://www.systemc.org/. Software distributed by Contributors
  under the License is distributed on an "AS IS" basis, WITHOUT WARRANTY OF
  ANY KIND, either express or implied. See the License for the specific
  language governing rights and limitations under the License.

 *****************************************************************************/

/*****************************************************************************

  MODIFICATION LOG - modifiers, enter your name, affiliation, date and
  changes you are making here.

      Name, Affiliation, Date:
  Description of Modification:

 *****************************************************************************/

// ============================================================================
//      Project : Generic SystemC TL Communication Methodology
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//         Date : 07/17/2003
//
//  Description : Transaction Level - Layer-3 data class.
//                Modules can use the data class to transport
//                data between Initiator and Target modules.
//                Contains member variables and access methods
//                to set or querry member variables.
//                The member variables are split in to two groups:
//                - Request-Channel members (set by Master read by Slave)
//                - Response-Channel members (set by Slave, read by Master)
//
// This is an example of an ATM Cell structure
//
// ============================================================================

// This file contains the definition of the classes:
// template <class Td> class TL3_DataCl

#ifndef _TL3_DATA_CL
#define _TL3_DATA_CL

template <class Td, class Ta> class TL3_DataCl
{
public:

  typedef Td DataType;
  typedef Ta AddrType;

  // Constructor
  TL3_DataCl()
  : ReqNumCells(0)
  , ReqCmd(0)
  , ReqAddress(0)
  , ResNumCells(0)
  , ResStatus(0)
  {
    // any value > 0 will do it
    int DefSize = 1;

    ReqData = new Td[DefSize];
    ResData = new Td[DefSize];
    m_ReqData = ReqData;
    m_ResData = ResData;
    m_ReqSize = DefSize;
    m_ResSize = DefSize;
  }

  // Destructor
  ~TL3_DataCl()
  {
    delete [] m_ReqData;
    delete [] m_ResData;
  }

//---------------------------------------------------------------------
// -------------- Start of access methods -------------------------------

// These three methods are used in the Channel,
// and hence they must always be present!

  bool IsWriteRequest()
  {
    return((ReqCmd == 1) ? true : false);
  }
  void SetWriteRequest()
  {
    ReqCmd = 1;
  }
  void SetReadRequest() 
  {
    ReqCmd = 2;
  }

  // Mandatory channel calls, not used in TL2
  void ToggleRequest(){}

  void ToggleDataRequest()  {}

  void ToggleResponse() {}

//-----------------------------------------------------------
// The following methods are needed to run the examples
// We recommend to use them in user applications as well
//
// These are access methods for data fields to
//   - make code more readable and
//   - make Master and Slave code independent of the
//     data structure. If a different data structure is used
//     only the data class must be changed but not Master and Slave code.
// This is a minimum set of methods.
// The following data fields are supported by access methods
// ReqData    : Pointer to the data sent by Master to Slave
// ResData    : Pointer to the data sent by Slave to Master
// ReqNumCells: Number of cells of the Master requests
// ResNumCells: Number of cells of the Slave response
// ReqCmd   : Flag specifying if the Master sends a read or write request
// ResCmd   : Flag specifying if the Slaves sends a read or write response
// ResStatus  : Status of the Slave response
//---------------------------

  // Access methods to ResCmd field.
  // ResCmd is needed in the pipelined case to identify whether the
  // Slave responses to a read or write request. 
  bool IsWriteResponse()
  {
    return((ResCmd == 1) ? true : false);
  }
  void SetWriteResponse()
  {
    ResCmd = 1;
  }
  void SetReadResponse()
  {
    ResCmd = 2;
  }
  int MgetResCmd()
  {
    return(ResCmd);
  }
  void SputResCmd(int Cmd)
  {
    ResCmd = Cmd;
  }

  // Number of ATM Cells
  void MputNumCells(int NumCells)
  {
    ReqNumCells = NumCells;
  }
  int SgetNumCells()
  {
    return(ReqNumCells);
  }
  void SputNumCells(int NumCells)
  {
    ResNumCells = NumCells;
  }
  int MgetNumCells()
  {
    return(ResNumCells);
  }

  // Slave response
  void SputStatus(int Resp)
  {
    ResStatus = Resp;
  }
  int MgetStatus()
  {
    return(ResStatus);
  }

  // Data transfer methods (pointer passing)
  void MputData(Td* d)
  {
    ReqData = d;
  }
  void MputData(Td* d, int w)
  {
    ReqNumCells = w;
    ReqData = d;
  }
  void SputData(Td* d)
  {
    ResData = d;
  }
  void SputData(Td* d, int w)
  {
    ResNumCells = w;
    ResData = d;
  }
  Td * MgetData()
  {
    return ResData;
  }
  Td * MgetData(int &w)
  {
    w = ResNumCells;
    return ResData;
  }
  Td * SgetData()
  {
    return ReqData;
  }
  Td * SgetData(int &w)
  {
    w = ReqNumCells;
    return ReqData;
  }

  // Data transfer methods (data copy)
  bool MputData(Td &d)
  {
    Td *x = &d;
    int NumBeats = SetNumBeats(ReqNumCells);

    if (Mrealloc(NumBeats))
    {
      for (int i = 0; i < NumBeats; i++)
        ReqData[i] = x[i];
      return(true);
    }
    else 
      return false;    
  }
  bool MputData(Td &d, int w)
  {
    Td *x = &d;
    ReqNumCells = w;
    int NumBeats = SetNumBeats(ReqNumCells);
    if (Mrealloc(NumBeats))
    {
      for (int i = 0; i < NumBeats; i++)
        ReqData[i] = x[i];
      return(true);
    }
    else 
      return false;    
  }
  bool SputData(Td &d)
  {
    Td *x = &d;
    int NumBeats = SetNumBeats(ResNumCells);
    if (Srealloc(NumBeats))
    {
      for (int i = 0; i < NumBeats; i++)
        ResData[i] = x[i];
      return(true);
    }
    else 
      return false;    
  }
  bool SputData(Td &d, int w)
  {
    Td *x = &d;
    ResNumCells = w;
    int NumBeats = SetNumBeats(ResNumCells);
    if (Srealloc(NumBeats))
    {
      for (int i = 0; i < NumBeats; i++)
        ResData[i] = x[i];
      return(true);
    }
    else 
      return false;    
  }
  void MgetData(Td* d)
  {
    int NumBeats = SetNumBeats(ResNumCells);
    for (int i = 0; i < NumBeats; i++)
      d[i] = ResData[i];
  }
  void MgetData(Td* d, int &w)
  {
    int NumBeats = SetNumBeats(ResNumCells);
    w = ResNumCells;
    for (int i = 0; i < NumBeats; i++)
      d[i] = ResData[i];
  }
  void SgetData(Td* d)
  {
    int NumBeats = SetNumBeats(ReqNumCells);
    for (int i = 0; i < NumBeats; i++)
      d[i] = ReqData[i];
  }
  void SgetData(Td* d, int &w)
  {
    int NumBeats = SetNumBeats(ReqNumCells);
    w = ReqNumCells;
    for (int i = 0; i < NumBeats; i++)
      d[i] = ReqData[i];
  } 


// -------------- End of access methods -------------------------------

// --------------- Request Channel data memebers ----------------------

  // Data pointer, contains the data in a write request
  Td *ReqData;

  // Length of a burst in units of words sent by Master to Slave
  // (write request)
  int ReqNumCells;

  // Identifies whether the Master request is a read or write request.
  int ReqCmd;

  // Only used for compliance with debug output in the channel
  Ta ReqAddress;

// --------------- Response Channel data memebers ---------------------

  // Data pointer, returns the data in a read request
  Td *ResData;

  // Length of a burst in units of words sent by Slave to Master
  // (read response)
  int ResNumCells;

  // Identifies whether the Slave responses to a read or write request.
  int ResCmd;

  // Slave response status. The following values are possible:
  // 
  int ResStatus;

private:

  bool Mrealloc(int NewSize)
  {
    ReqData = m_ReqData;
    if (m_ReqSize < NewSize)
    {
      delete [] ReqData;
      try
      {
        ReqData = new Td[NewSize];
        m_ReqData = ReqData;
      }
      catch(std::bad_alloc ex)
      {
        cerr << "ERROR: Memory allocation for data array failed "
             << "tl3_data_cl.h" << ">" << endl;
        cerr << "       Size  is: " << NewSize << endl;
        cerr << "       Error is: " << ex.what() << endl;
        sc_stop();
        return(false);
      }
      m_ReqSize = NewSize;
    }
    return(true);
  }

  bool Srealloc(int NewSize)
  {
    ResData = m_ResData;
    if (m_ResSize < NewSize)
    {
      delete [] ResData;
      try
      {
        ResData = new Td[NewSize];
        m_ResData = ResData;
      }
      catch(std::bad_alloc ex)
      {
        cerr << "ERROR: Memory allocation for data array failed "
             << "tl3_data_cl.h" << ">" << endl;
        cerr << "       Size  is: " << NewSize << endl;
        cerr << "       Error is: " << ex.what() << endl;
        sc_stop();
        return(false);
      }
      m_ResSize = NewSize;
    }
    return(true);
  }

  inline int SetNumBeats(int NumWords)
  { // nothing to do
    return(NumWords);
  }

  // Used for data copying
  int m_ReqSize;
  int m_ResSize;
  Td  *m_ReqData;
  Td  *m_ResData;
};

#endif // _TL3_DATA_CL
