/*
  This file contains classes master, slave
  and top level netlist for simple TL3 point-to-point demo
*/


#define DEBUG

#include <systemc.h>
#include "ocp_tl3_globals.h"
// Use TL2 data class for TL3
#include "ocp_tl2_data_cl.h"
#include "tl_channel.h"  


typedef struct message_tag {
  int header;
  const char *datum;
} message_T;

// Copyright (c 2003 OCP-IP
// Simple TL3 master

#include "tl_master_if.h"

SC_MODULE(master) {
  
  // Port definitions
  sc_port<TLmasterIF<OCP_TL2_DataCl<message_T, int> > > ocp;

  void request_thread () {

    for (int msg_cnt=0;msg_cnt<3;msg_cnt++) {
      switch (msg_cnt) {
      case 0:
	wdata.datum = "Hello";
	wdata.header = 6;
	break;
      case 1:
	wdata.datum = "How are ya?";
	wdata.header = 12;
	break;
      case 2:
	wdata.datum = "Good";
	wdata.header = 5;
	break;
      }
#ifdef DEBUG
      cout << "Master sends message" << endl;
#endif
      ocp->GetDataCl()->MputMData(&wdata); 
      ocp->MputWriteRequestBlocking();

      if (ocp->MgetResponseBlocking(1)) {
	rdata = ocp->GetDataCl()->MgetSData();
#ifdef DEBUG
	cout << "Master gets message: ";
	for (int i=0;i<rdata->header-1;i++)
	  cout << rdata->datum[i];
	cout << endl;
#endif
      }	  
    }
  }
  
  
  SC_CTOR(master) {
    SC_THREAD(request_thread);
  }
  
  message_T wdata, *rdata;
  
};



// Copyright (c 2003 OCP-IP
// Simple TL3 slave

#include "tl_slave_if.h"

SC_MODULE(slave) {
  
  // Port definitions
  sc_port<TLslaveIF<OCP_TL2_DataCl<message_T, int> > > ocp;
  
  // Globals
  message_T *wdata, rdata;
  
  void response_thread () {
    bool tmp;
    
    for (int msg_cnt=0;msg_cnt<3;msg_cnt++) {
      tmp = ocp->SgetRequestBlocking(1);
      if (tmp) {
	wdata = ocp->GetDataCl()->SgetMData(); 
#ifdef DEBUG
	cout << "Slave gets message: ";
	for (int i=0;i<wdata->header-1;i++)
	  cout << wdata->datum[i];
	cout << endl;
#endif
#ifdef DEBUG
	cout << "Slave sends message" << endl;;
#endif
	switch (msg_cnt) {
	case 0:
	  rdata.datum = "Hello";
	  rdata.header = 6;
	  break;
	case 1:
	  rdata.datum = "Good";
	  rdata.header = 5;
	  break;
	case 2:
	  rdata.datum = "Good";
	  rdata.header = 5;
	  break;
	}
	ocp->GetDataCl()->SputSData(&rdata);
	tmp = ocp->SputResponseBlocking();
      }
    }
  }
  
  SC_CTOR(slave) {
    SC_THREAD(response_thread);
  }

};




// Copyright (c 2003 OCP-IP
// Top level netlist for simple TL3 example

int sc_main(int, char*[])
{

  bool sync = true;
  TL_Channel<OCP_TL2_DataCl<message_T, int> >  ch0("ch0", sync);

  slave sl1("sl1");
  master ms1("ms1");

  ms1.ocp(ch0);

  sl1.ocp(ch0);

  sc_start(20000, SC_MS);

  return(0);
}

