// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stphane Guntz, PROSILOG, guntz@prosilog.com
//         Date : 03/10/2003 
//
//  Description : Layer Adapter, TL0-TL1 example, Asynchronous TL0 OCP Master 
// ============================================================================

#ifndef _TL0_OCP_MASTER_ASYNC_H
#define _TL0_OCP_MASTER_ASYNC_H

#include "ocp_tl1_globals.h"

using namespace std;

// ----------------------------------------------------------------------------
// Class : OCP_TL0_Master_async 
// 
// Description: Asynchronous TL0 OCP Master 
// ----------------------------------------------------------------------------

template <class TdataCl> class OCP_TL0_Master_async
  : public sc_module
{
public:

  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  // Basic OCP ports
  sc_in   <bool>      Clk;
  sc_out  <sc_bv<3> >	MCmd;
  sc_out 	<Ta>      	MAddr;
  sc_out 	<Td>      	MData;
  sc_in	  <bool>	    SCmdAccept;
  sc_in	  <Td>      	SData;
  sc_in	  <sc_bv<2> > SResp;
  sc_out 	<bool>	    MRespAccept;

  SC_HAS_PROCESS(OCP_TL0_Master_async);

  // constructor
  OCP_TL0_Master_async(sc_module_name name_
            , sc_time RequestDelay = sc_time(0)
            , sc_time ResponseDelay = sc_time(0)
           );

  // destructor
  ~OCP_TL0_Master_async();

  // methods
  void GetResponse();
  void SendRequest();

  // Master parameters
  sc_time   m_RequestDelay;
  sc_time   m_ResponseDelay;

};


#endif // _TL0_OCP_MASTER_ASYNC_H
