#ifndef _OCP_TL1_PERF_MONITOR_WRAPPER_H
#define _OCP_TL1_PERF_MONITOR_WRAPPER_H

#include "ocp_tl1_monitor_if.h"
#include "ocp_tl2_monitor_if.h"

template <typename TDataCl>
class OCP_Tl1_Perf_Monitor_Wrapper : 
  public OCP_TL2_MonitorPeekIF<typename TDataCl::DataType,
			       typename TDataCl::AddrType>
{
public:
  typedef OCP_TL1_MonitorIF<TDataCl> tl1_peek_type;
  typedef typename tl1_peek_type::request_type tl1_request_type;
  typedef typename tl1_peek_type::response_type tl1_response_type;
  typedef OCP_TL2_MonitorPeekIF<typename TDataCl::DataType,
				typename TDataCl::AddrType> tl2_peek_type;
  typedef typename tl2_peek_type::request_type tl2_request_type;
  typedef typename tl2_peek_type::response_type tl2_response_type;

  OCP_Tl1_Perf_Monitor_Wrapper(tl1_peek_type* tl1_channel):
    m_tl1_channel(tl1_channel)
  {
  }
  
  //----------------------------------------------------------------------
  // Monitor methods
  //----------------------------------------------------------------------
  const string peekChannelName() const
  { 
    return m_tl1_channel->peekChannelName(); 
  }
  const string peekMasterPortName() const
  {
    return  m_tl1_channel->peekMasterPortName();
  }
  const string peekSlavePortName() const
  {
    return m_tl1_channel->peekSlavePortName();
  }
  const tl2_request_type& peekOCPRequest() const
  {
    return m_tl2_request;
  }
  const tl2_response_type& peekOCPResponse() const
  {
    return m_tl2_response;
  }
  bool requestInProgress() const
  {
    return ( m_tl1_channel->peekRequestStart() && 
	     !m_tl1_channel->peekRequestEnd());
  }
  bool responseInProgress() const
  {
    return ( m_tl1_channel->peekResponseStart() && 
	     !m_tl1_channel->peekResponseEnd());
  }

  const unsigned int peekMThreadBusy() const
  {
    return m_tl1_channel->peekMThreadBusy();
  }
  const unsigned int peekSThreadBusy() const
  {
    return m_tl1_channel->peekSDataThreadBusy();
  }
  const MTimingGrp& peekMasterTiming() const
  {
    return m_mtiming;
  }
  const STimingGrp& peekSlaveTiming()	const
  {
    return m_stiming;
  }
  // timing helper
  int getWDI() const { return 0; } 
  int getRqI() const { return 0; } 
  int getTL2ReqDuration() const { return 0; } 
  int getRDI() const { return 0; } 
  int getTL2RespDuration() const { return 0; } 

  // reset
  bool getReset() 
  {
    return ( m_tl1_channel->peekMReset_n() ||
	     m_tl1_channel->peekSReset_n() );
  }
  
  const OCPSidebandGrp&	peekSideband() const
  {
    return m_sideband;
  }

  OCPParameters* GetParamCl() 
  {
    return m_tl1_channel->GetParameters();
  }


  void setRequest(const tl1_request_type& tl1_req) {
    m_tl2_request.copyFrom(tl1_req,tl1_req.MBurstLength);
  }

  void setResponse(const tl1_response_type& tl1_resp) {
    m_tl2_response.copyFrom(tl1_resp,1);
  }

protected:
  tl1_peek_type*	m_tl1_channel;
  tl2_request_type	m_tl2_request;
  tl2_response_type	m_tl2_response;

  // dummy members
  MTimingGrp m_mtiming;
  STimingGrp m_stiming;
  OCPSidebandGrp m_sideband;
};


#endif
