#ifndef _ocpip_array_stack_h_
#define _ocpip_array_stack_h_

#include <vector>
#include <deque>

// Keeps data array memory for reuse
template <class Td>
class ArrayStack {
  public:
    ArrayStack( int arraySize=1024 ) :
        m_arraySize( arraySize ) {}    

    ~ArrayStack() {
        // Clean up all of the pointers still in the recycle pile
        for ( typename std::vector<Td*>::iterator it = recyclePile.begin();
              it != recyclePile.end(); ++it )
            delete[] *it;
        recyclePile.clear();
    }

    Td *getNew() {
        // Can we reuse an old data array?
        if (!recyclePile.empty()) {
            Td *myPtr = recyclePile.back();
            recyclePile.pop_back();
            return myPtr;
        }
        // Nothing in the recycle pile, make a new one 
        return new Td[m_arraySize];
    }

    void recycle(Td *old) {
        // Toss the pointer unto the pile
        recyclePile.push_back( old );
    }

  private:
    std::vector<Td*> recyclePile;
    const int        m_arraySize;
};

#endif // _ocpip_array_stack_h_
