// 
//  (c) Copyright OCP-IP 2003, 2004
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, Layer adapter examples 
//      Authors : Yann Bajot, PROSILOG, bajot@prosilog.com 
//                Stephane Guntz, PROSILOG, guntz@prosilog.com
//
//  Description : Simple OCP master for Layer-1 to Layer-2 Slave Adapter (OCP 2.0 supported)
//  $Id: simple_ocp_master_tl2.cpp,v 1.2 2005/10/06 20:34:47 halexan Exp $
//
//  The master sends the following sequence of requests:
//
//	- a WRITE burst composed of one chunk: length=20, start address=0
//	- a READ burst composed of one chunk:  length=10, start address=0
//	then it waits for 2 nanoseconds
//	- a READ burst composed of two chunks: total length=8, first chunk length=4, second chunk length=4, start address=0
//	the master waits for 2 nanoseconds after the first chunk, and 3 nanoseconds after the second chunk
//	- a WRITE burst composed of one chunk: length=15, start address=0
//
// On the response side, the master releases the response channel after a 2 nanoseconds waiting period
//
// ============================================================================


#include "simple_ocp_master_tl2.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------
simple_ocp_master_tl2::simple_ocp_master_tl2(sc_module_name mod):
       sc_module(mod),
    MasterP("MasterP")
    {
        // Init Master Data array
        for (unsigned int i=0;i<100;i++)
            wdata[i] = i;

		SC_THREAD(request_thread);
		SC_THREAD(response_thread);
    }
		


void simple_ocp_master_tl2::request_thread () {

	bool result=false;

    // Prepares the WRITE complete transaction (20-length WRITE burst): 
    // Set the members of the request group structure that have changed
    m_req.MCmd            =     OCP_MCMD_WR;    // this is a WRITE transaction
    m_req.MDataPtr        =     wdata;          // pass a pointer to the master data array
    m_req.MAddr           =     0;
    m_req.MAddrSpace      =     0;
    m_req.MByteEn         =     0xf;
    m_req.MConnID         =     0x0;            
    m_req.MReqInfo        =     0x0;        
    m_req.MAtomicLength   =     0x0;
	//burst precise:
	//m_req.MBurstLength    =     20;
	//burst imprecise:
	m_req.MBurstLength  =     1;  //last chunk of an imprecise burst
    m_req.MBurstPrecise =     0x0;
    m_req.MBurstSeq       =     OCP_MBURSTSEQ_INCR;
    m_req.MBurstSingleReq =     0x0;
    m_req.MReqLast        =     0x1;     
    
	// Sets TL2-specific fields
    //  this request is sent using a single TL2 chunk
    unsigned int Transaction_length = 20;

     // Sends the WRITE transaction and test everything is OK
	cout << "Master starts sending WRITE TRANSACTION -- " << sc_time_stamp() << endl;
    result=MasterP->sendOCPRequestBlocking(m_req,Transaction_length);

	//check if the Request has been put into the channel
	assert(result);
    
    // Display the sent data
    cout << "Master ends sending WRITE TRANSACTION -- " << sc_time_stamp() << endl;
    for (unsigned int  i=0; i< Transaction_length; i+=1 ) {
        cout << m_req.MDataPtr[i] << " " ;
    }
    cout << endl;


    // Prepares the first request (10-length READ burst): 
    // Set the members of the request group structure
    m_req.MCmd            =     OCP_MCMD_RD;    // this is a WRITE transaction
    m_req.MDataPtr        =     wdata;          // pass a pointer to the master data array
    m_req.MThreadID       =     0x0;            // request is sent by the thread 1
        
    m_req.MAddr           =     0;
    m_req.MAddrSpace      =     0;
    m_req.MByteEn         =     0xf;
    m_req.MConnID         =     0x0;            
    m_req.MReqInfo        =     0x0;        
    m_req.MAtomicLength   =     0x0;
	//burst precise:
    //m_req.MBurstLength    =     10;
	//burst imprecise:
	m_req.MBurstLength  =     1;  //last chunk of an imprecise burst
    m_req.MBurstPrecise   =     0x0;
    m_req.MBurstSeq       =     OCP_MBURSTSEQ_INCR;
    m_req.MBurstSingleReq =     0x0;
    m_req.MReqLast        =     0x1;

    // Sets TL2-specific fields
    //  this request is sent using a single TL2 chunk
    unsigned int ReqChunkLen = 10;
    bool ReqChunkLast = true;

 
    // Sends the request and test everything is OK
    cout << "Master starts sending request 1 -- " << sc_time_stamp() << endl;
    result=MasterP->sendOCPRequestBlocking(m_req,ReqChunkLen,ReqChunkLast);

	//check if the Request has been put into the channel
	assert(result);

    cout << "Master ends sending request 1 -- " << sc_time_stamp() << endl;

    // Display the sent data
    for (unsigned int  i=0; i< ReqChunkLen; i+=1 ) {
        cout << m_req.MDataPtr[i] << " " ;
    }
    cout << endl;

    // wait some time
    wait(2,SC_NS);


	 // Prepares the second request (8-length READ burst): 
    // Set the members of the request group stucture
    m_req.MCmd            =     OCP_MCMD_RD;    // this is a WRITE transaction
    m_req.MDataPtr        =     wdata;          // pass a pointer to the master data array
    m_req.MThreadID       =     0x0;            // request is sent by the thread 1
        
    m_req.MAddr           =     0;
    m_req.MAddrSpace      =     0;
    m_req.MByteEn         =     0xf;
    m_req.MConnID         =     0x0;            
    m_req.MReqInfo        =     0x0;        
    m_req.MAtomicLength   =     0x0;
    //burst precise:
	//m_req.MBurstLength    =     8;
	//burst imprecise:
	m_req.MBurstLength    =     8;
    m_req.MBurstPrecise   =     0x0;
    m_req.MBurstSeq       =     OCP_MBURSTSEQ_INCR;
    m_req.MBurstSingleReq =     0x0;
    m_req.MReqLast        =     0x0;

    // Sets TL2-specific fields
	//  this request is sent using two TL2 chunks
    ReqChunkLen = 4;
    ReqChunkLast = false;

	// Sends the request and test everything is OK
	cout << "Master starts sending first chunk of request 2 -- " << sc_time_stamp() << endl;
    result=MasterP->sendOCPRequestBlocking(m_req,ReqChunkLen,ReqChunkLast);

	//check if the Request has been put into the channel
	assert(result);

    cout << "Master ends sending first chunk of request 2 -- " << sc_time_stamp() << endl;

    // Display the sent data
    for (unsigned int  i=0; i< ReqChunkLen; i+=1 ) {
        cout << m_req.MDataPtr[i] << " " ;
    }
    cout << endl;

    // wait some time
    wait(3,SC_NS);
	m_req.MReqLast        =     0x1;
	//burst imprecise:
	m_req.MBurstLength    =     1;  //last chunk of an imprecise burst
	ReqChunkLen = 4;
    ReqChunkLast = true;

	// Sends the request and test everything is OK
	cout << "Master starts sending second chunk of request 2 -- " << sc_time_stamp() << endl;
    result=MasterP->sendOCPRequestBlocking(m_req,ReqChunkLen,ReqChunkLast);

	//check if the Request has been put into the channel
	assert(result);

    cout << "Master ends sending second chunk of request 2 -- " << sc_time_stamp() << endl;

    // Display the sent data
    for (unsigned int  i=0; i< ReqChunkLen; i+=1 ) {
        cout << m_req.MDataPtr[i] << " " ;
    }
    cout << endl;

    // wait some time
    wait(3,SC_NS);

    // Prepares the WRITE complete transaction (15-length WRITE burst): 
    // Set the members of the request group structure that have changed
	m_req.MReqLast        =     0x1;
    m_req.MCmd            =     OCP_MCMD_WR;    // this is a WRITE transaction
    m_req.MDataPtr        =     wdata;          // pass a pointer to the master data array
    m_req.MAddr           =     0;
    m_req.MAddrSpace      =     0;
	//burst imprecise:
	//m_req.MBurstLength    =     15; 
	//burst imprecise:
	m_req.MBurstLength    =     1; 
    // Sets TL2-specific fields
    //  this request is sent using a single TL2 chunk
    Transaction_length = 15;

    // Sends the WRITE transaction and test everything is OK
    cout << "Master starts sending WRITE TRANSACTION -- " << sc_time_stamp() << endl;
    MasterP->sendOCPRequestBlocking(m_req,Transaction_length);

	//check if the Request has been put into the channel
	assert(result);
    
    // Display the sent data
    cout << "Master ends sending WRITE TRANSACTION -- " << sc_time_stamp() << endl;
    for (unsigned int  i=0; i< Transaction_length; i+=1 ) {
        cout << m_req.MDataPtr[i] << " " ;
    }
    cout << endl;

    // wait some time
   // wait(100,SC_NS); 

	cout<<"\n\n-------------Master ends sending requests-------------- \n\n"<<endl;
}



void simple_ocp_master_tl2::response_thread () {
// The channel will be not released immediatly 
    bool release_immediatly = false;

	bool response_available=false;

    // get the first response chunk, checks that the SThreadID matches, and
    // retrieves chunk parameters
    unsigned int RespChunkLen=0;
    bool RespChunkLast=false;

	cout << "Master starts getting response chunk 1 of burst 1-- " << sc_time_stamp() << endl;
	response_available=MasterP->getOCPResponseBlocking(m_resp,release_immediatly,RespChunkLen,RespChunkLast);

	//check if a response is available
	assert(response_available);


	// Display the received data
	cout<<"Master has received the following data at t= "<<sc_time_stamp()<<" :"<<endl;
	for ( unsigned int i=0; i< RespChunkLen; i+=1 ) {
		cout << m_resp.SDataPtr[i] << " " ;
	}
	cout << endl;

	// release the response after some delay
	wait(2,SC_NS);
	MasterP->putMRespAccept();
	cout << "Master ends getting response chunk  1 of burst 1-- " << sc_time_stamp() << endl;

	// get the second response chunk, checks that the SThreadID matches, and
    // retrieves chunk parameters
  
	cout << "Master starts getting response chunk 2  of burst 1-- " << sc_time_stamp() << endl;
	response_available=MasterP->getOCPResponseBlocking(m_resp,release_immediatly,RespChunkLen,RespChunkLast);
	
	//check if a response is available
	assert(response_available);

	// Display the received data
	cout<<"Master has received the following data at t= "<<sc_time_stamp()<<" :"<<endl;
	for ( unsigned int i=0; i< RespChunkLen; i+=1 ) {
		cout << m_resp.SDataPtr[i] << " " ;
	}
	cout << endl;

	// release the response after some delay
	wait(2,SC_NS);
	MasterP->putMRespAccept();
	cout << "Master ends getting response chunk 2 of burst 1-- " << sc_time_stamp() << endl;


	// get the first chunk of the second burst, checks that the SThreadID matches, and
    // retrieves chunk parameters
  
	cout << "Master starts getting response chunk 1 of burst 2 -- " << sc_time_stamp() << endl;
	response_available=MasterP->getOCPResponseBlocking(m_resp,release_immediatly,RespChunkLen,RespChunkLast);
	
	//check if a response is available
	assert(response_available);

	// Display the received data
	cout<<"Master has received the following data at t= "<<sc_time_stamp()<<" :"<<endl;
	for ( unsigned int i=0; i< RespChunkLen; i+=1 ) {
		cout << m_resp.SDataPtr[i] << " " ;
	}
	cout << endl;

	// release the response after some delay
	wait(2,SC_NS);
	MasterP->putMRespAccept();
	cout << "Master ends getting response chunk 1 of burst 2-- " << sc_time_stamp() << endl;

	// get the second chunk of the second burst, checks that the SThreadID matches, and
    // retrieves chunk parameters
  
	cout << "Master starts getting response chunk 2 of burst 2 -- " << sc_time_stamp() << endl;
	response_available=MasterP->getOCPResponseBlocking(m_resp,release_immediatly,RespChunkLen,RespChunkLast);

	//check if a response is available
	assert(response_available);

	// Here we are cheating because we know what the slave sends
	assert(RespChunkLen == 3);      
	assert(RespChunkLast == true);

	// Display the received data
	cout<<"Master has received the following data at t= "<<sc_time_stamp()<<" :"<<endl;
	for ( unsigned int i=0; i< RespChunkLen; i+=1 ) {
		cout << m_resp.SDataPtr[i] << " " ;
	}
	cout << endl;

	// release the response after some delay
	wait(2,SC_NS);
	MasterP->putMRespAccept();
	cout << "Master ends getting response chunk 2 of burst 2-- " << sc_time_stamp() << endl;
	


	cout<<"\n\n------Master ends getting the responses-------\n\n"<<endl;

}
