// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                (modified by Joe Chou, Sonics Inc., joechou@sonicsinc.com)
//         Date : 01/05/2004
//
//  Description : Transaction Level - Layer-2 Master example.
//
// ============================================================================

#ifndef _OCP_TL2_MASTER_H
#define _OCP_TL2_MASTER_H

#include "systemc.h"
#include "ocp_globals.h"
#include "ocp_tl_param_cl.h"
#include "ocp_tl2_data_cl.h"
#include "tl_master_if.h"
#include "ocp_tl2_master_port.h"

// maximum number of items sent in one burst
const int TL2_MAX_BURST_LENGTH = 60;

const sc_time_unit TL_TIME_SCALE = SC_NS;       // clock period
const double TL_TIME_SCALE_SEC   = 0.000000001;

// Allowed Slave response values
const int TL_SRESP_OK    = 1;
const int TL_SRESP_ERROR = 3;



template <class TdataCl> class OCP_TL2_Master
  : public sc_module,
    public MdirectIF<TdataCl>
{
public:

  //
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  OCP_TL2_MasterPort<int, int> MasterP;

  //
  SC_HAS_PROCESS(OCP_TL2_Master);

  // constructor
  OCP_TL2_Master(sc_module_name name_, int ID, int Priority,
    bool Pipelined = false, bool WriteResponse = true,
    int ReadRequestCycles = 0, int WriteRequestCycles = 0,
    int ReadAcceptCycles = 0, int WriteAcceptCycles = 0);

  // destructor
  ~OCP_TL2_Master();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);

  //
  void MasterD();
  void Master();
  void MasterRequest();
  void MasterResponse();
  bool SetNumWords(int NumWords);
  bool CompareData(Td* DataW, Td* DataR, int NumWords);
  void PrintTrans(int TaNum, Ta Addr, const char* Method);
  void PrintError();
  void PrintSresp(OCPSRespType m_Sresp, int m_TaNum, Ta m_Saddr);
  void PrintTime(const char* Pstring, int ID, Ta Addr);

private:

  //
  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl*          m_DataCl;
  ParamCl<TdataCl>* m_ParamCl;
  CommCl*           m_CommCl;

  // Master parameters
  int  m_ID;
  int  m_Priority;
  bool m_Pipelined;
  bool m_WriteResponse;
  int  m_ReadRequestCycles;
  int  m_WriteRequestCycles;
  int  m_ReadAcceptCycles;
  int  m_WriteAcceptCycles;

  // Data arrays
  Td m_DirectDataW[TL2_MAX_BURST_LENGTH];
  Td m_DirectDataR[TL2_MAX_BURST_LENGTH];
  Td m_DataW[TL2_MAX_BURST_LENGTH];
  Td m_DataR[TL2_MAX_BURST_LENGTH];

  // Constants
  int m_Write;
  int m_Read;

  //
  int m_NumWords;
  unsigned int m_SNumWords;
  int m_NumBytesPerWord;

  //
  OCPSRespType m_Sresp; // Slave response
  Td*          m_Sdata;
  Ta           m_Saddr; // Address of the Slave who sends the response

  //
  int m_TaNum; // Transaction number
  int m_TaNumS; // Transaction number
};

#endif // _OCP_TL2_MASTER_H
