// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//         Date : 02/15/2003
//
//  Description : Transaction Level - Layer-1 example Master
//
// ============================================================================

#ifndef _OCP_TL1_MASTER_SYNC_SIDEBAND_H
#define _OCP_TL1_MASTER_SYNC_SIDEBAND_H

#include "ocp_tl1_globals.h"
#include "tl_master_if.h"

#include "ModelConfigCl.h"

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

// NOTE: need to change the class name to *_Sideband
template <class TdataCl> class OCP_TL1_Master_Sync_Sideband
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<TLmasterIF<TdataCl>, 1> MasterP;
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master_Sync_Sideband);

  // constructor
  OCP_TL1_Master_Sync_Sideband(sc_module_name name_
             , int ID
             , int Priority
             , double DelayPct
            );

  // destructor
  ~OCP_TL1_Master_Sync_Sideband();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();
  void MasterSetSideband();

  void setConfiguration(string name, ModelConfigCl& MCDatabase) {
      MCDatabase.getInstanceConfiguration(name,m_Map);
  };

  void dumpConfiguration(void) {
    cout << endl << "Map:" << endl;
    MAPType::iterator map_it;
    for (map_it = m_Map.begin(); map_it != m_Map.end(); ++map_it) {
        cout << "map[" << map_it->first << "] = " << map_it->second
             << endl;
    }

    int latency = atoi(m_Map[".ms1.latency"].c_str()+2);

    cout << endl << "The latency parameter is: " << latency
         << endl << endl;
  }

private :

  void end_of_elaboration();

  // Pointer to the data structures of the channel
  TdataCl          *m_DataCl;
  ParamCl<TdataCl> *m_ParamCl;
  CommCl           *m_CommCl;

  // parameters
  int m_ID;
  int m_Priority;
  double m_DelayPct;

  //
  MAPType m_Map;
};


#endif // _OCP_TL1_MASTER_SYNC_SIDEBAND_H
