// 
//  (c) Copyright OCP-IP 2003
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Joe Chou, Sonics Inc., joechou@sonicsinc.com 
//                Alan Kamas for Sonics Inc., aok@sonicsinc.com, www.kamas.com
//         Date : 10/28/2003
//
//  Description : OCP Transaction Level communication class.
//                This class gives the modules read access to
//                the events and states used in the Channel.
//                We recommend users not to change this class.
//
// ============================================================================

// This file contains the definition of the classes:
// class CommCl


#ifndef _TL_Comm_CL
#define _TL_Comm_CL

// This class contains the states and events used by the
// communication mechanism of the Channel. These states and events
// must not be changed by Masters and Slaves.
// The purpose to export these states and events is to
// give Masters and Slaves read access. Again, these access must be read only.
// For the (intended) normal use of the Channel this class should not be
// changed.

// NOTE: There are some states that may not be needed:
// NOTE: May want to remove: GetRequestPending
// NOTE: May want to remove all of the PE states
class CommCl
{
 public:

  // Constructor
  CommCl()
    : RequestStart(false)
    , RequestEnd(false)
    , RequestEndTime(-1.0)
    , ResponseStart(false)
    , ResponseEnd(false)
    , ResponseEndTime(-1.0)
    , DataRequestStart(false)
    , DataRequestEnd(false)
    , DataRequestEndTime(-1.0)
    , RequestPending(false)
    , DataRequestPending(false)
    , BlockingRequestPending(false)
    , BlockingDataRequestPending(false)
    , BlockingGetRequestPending(false)
    , BlockingGetDataRequestPending(false)
    , ResponsePending(false)
    , BlockingResponsePending(false)
    , BlockingGetResponsePending(false)
    , RequestTogglePE(false)
    , DataRequestTogglePE(false)
    , ResponseTogglePE(false)
    , RequestUnread(false)
    , DataRequestUnread(false)
    , ResponseUnread(false)
    , Reset(false)
  {
      reset();
  }

  void
  reset(void)
  {
     RequestStart = false;
     RequestEnd = false;
     RequestEndTime = -1.0;
     ResponseStart = false;
     ResponseEnd = false;
     ResponseEndTime = -1.0;
     DataRequestStart = false;
     DataRequestEnd = false;
     DataRequestEndTime = -1.0;
     RequestPending = false;
     DataRequestPending = false;
     BlockingRequestPending = false;
     BlockingDataRequestPending = false;
     BlockingGetRequestPending = false;
     BlockingGetDataRequestPending = false;
     ResponsePending = false;
     BlockingResponsePending = false;
     BlockingGetResponsePending = false;
     RequestTogglePE = false;
     DataRequestTogglePE = false;
     ResponseTogglePE = false;
     RequestUnread = false;
     DataRequestUnread = false;
     ResponseUnread = false;
     RequestPendingPE[0] = false;
     RequestPendingPE[1] = false;
     DataRequestPendingPE[0] = false;
     DataRequestPendingPE[1] = false;
     ResponsePendingPE[0] = false;
     ResponsePendingPE[1] = false;
  }
      
  // States for non-blocking and blocking synchronization
  bool RequestStart;
  bool RequestEnd;
  double RequestEndTime;
  bool ResponseStart;
  bool ResponseEnd;
  double ResponseEndTime;
  bool DataRequestStart;
  bool DataRequestEnd;
  double DataRequestEndTime;
  bool RequestPending;
  bool DataRequestPending;
  bool BlockingRequestPending;
  bool BlockingDataRequestPending;
  bool GetDataRequestPending;
  bool BlockingGetRequestPending;
  bool BlockingGetDataRequestPending;
  bool ResponsePending;
  bool BlockingResponsePending;
  bool BlockingGetResponsePending;
  bool RequestTogglePE;
  bool DataRequestTogglePE;
  bool ResponseTogglePE;
  bool RequestUnread;   // Is the current request still unread by the Slave?
  bool DataRequestUnread;  // Is the current data still unread by the Slave?
  bool ResponseUnread;  // Is the current response still unread by the Slave?
  bool RequestPendingPE[2];
  bool DataRequestPendingPE[2];
  bool ResponsePendingPE[2];

  // States for Reset
  bool Reset;   // Active High reset flag

  // Events for blocking synchronization
  sc_event RequestStartEvent;
  sc_event RequestEndEvent;
  sc_event DataRequestStartEvent;
  sc_event DataRequestEndEvent;
  sc_event ResponseStartEvent;
  sc_event ResponseEndEvent;
  sc_event RequestEndEventN;
  sc_event DataRequestEndEventN;
  sc_event ResponseEndEventN;

  // default event to indicate port access
  sc_event StartEvent;

  // Events for reset
  sc_event ResetStartEvent;
  sc_event ResetEndEvent;

 private:
};

#endif // _TL_Comm_CL
