// 
//  Copyright 2003 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level Layer-1
//       Author : Norman Weyrich, Synopsys Inc., weyrich@synopsys.com
//                Anssi Haverinen, Nokia Inc., anssi.haverinen@nokia.com
//                Yann Bajot, Prosilog, bajot@prosilog.com
//         Date : 01/15/2004
//
//  Description : Transaction Level - Layer-1 example Master (OCP 2.0)
//               (with Datahandshake support)
// ============================================================================

#ifndef _OCP_TL1_MASTER_ASYNC_HS_H
#define _OCP_TL1_MASTER_ASYNC_HS_H

#include "systemc.h"

#include "ocp_globals.h"
#include "ocp_tl1_master_if.h"

// Timings are defined in the testbench (top*.cpp)
extern const sc_time_unit TL_TIME_UNIT; 
extern const double TL_CLK_PERIOD ;     // clock period

// could be used to configure the data class, not needed in this example
#ifndef TL_SYNCHRON_DATA_CL
#define TL_SYNCHRON_DATA_CL true
#endif

template <class TdataCl> class OCP_TL1_Master_Async_hs
  : public sc_module
  , public MdirectIF<TdataCl>
{
public:  
  
  typedef typename TdataCl::DataType Td;
  typedef typename TdataCl::AddrType Ta;

  sc_port<OCP_TL1_MasterIF<TdataCl>, 1> MasterP;
  
  sc_in_clk  clk;

  SC_HAS_PROCESS(OCP_TL1_Master_Async_hs);

  // constructor
  OCP_TL1_Master_Async_hs(sc_module_name name_
             , int ID
             , int Priority
             , double RequestDelay
             , double DataDelay
             , double ResponseDelay
            );

  // destructor
  ~OCP_TL1_Master_Async_hs();

  // methods
  virtual bool SputDirect(int, bool, Td*, Ta, int);
  void MasterRequest();
  void MasterResponse();


private :

  void end_of_elaboration();
  
  // Structures used to handle TL1 Requests/Responses
  OCPResponseGrp<Td>   TL1_response;
  OCPRequestGrp<Td,Ta>   TL1_request;
  OCPDataHSGrp<Td>   TL1_dataHS;

  // parameters
  int m_ID;
  int m_Priority;
  double m_RequestDelay;
  double m_DataDelay;
  double m_ResponseDelay;
};


#endif // _OCP_TL1_MASTER_ASYNC_HS_H
