// 
//  Copyright 2004 OCP-IP
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Anssi Haverinen, Nokia Inc.
//         $Id: slave.cc,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : Generic API - Layer-1 Simple Example pipelined slave
// ============================================================================

#include "slave.h"

// ----------------------------------------------------------------------------
// Constructor
// ----------------------------------------------------------------------------

template<class TdataCl> Slave<TdataCl>::Slave (sc_module_name name_)
  : sc_module (name_), tpP("tpPort") {

  // initialize common members
  is_req = false;
  tmp = false;
  last_request = OCP_MCMD_IDLE;

  SC_THREAD(proc_req);
  sensitive_pos(clk);
  SC_THREAD(proc_resp);
  sensitive(send_response_event);
}


// ----------------------------------------------------------------------------
// Destructor
// ----------------------------------------------------------------------------
template<class TdataCl> Slave<TdataCl>::~Slave(){}


// ----------------------------------------------------------------------------
//  Method : Slave::proc_req()
//
//  Slave request receive process
//
// ----------------------------------------------------------------------------

template<class TdataCl> void Slave<TdataCl>::proc_req(){
  bool release = false;
  unsigned int size;
  bool last = true;
  int mdata;
  sc_time delay = sc_time(2, SC_NS);

  while (true) {
    wait(); // for clock
    // Check for request
    is_req = tpP->SgetRequest(release);
    if (is_req) {
      tpP->Srelease(); // Release master
      // If request was write
      if (tpP->IsWrite()) {
	mdata = m_DataCl->SgetMData(); 
#ifdef DEBUG_G1
	cout << "Slave got write request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  data  = " << mdata << endl;
#endif

      }
      else {
	
#ifdef DEBUG_G1
	cout << "Slave got read request "
	     << "  time  = " << sc_time_stamp().to_seconds()
	     << "  address  = " << m_DataCl->SgetMAddr() << endl;
#endif
	// Trigger response thread
	send_response_event.notify(delay);
      }
    }
  }
} // end of method

// ----------------------------------------------------------------------------
//  Method : Slave::proc_resp()
//
//  Slave response process.
//
// ----------------------------------------------------------------------------
template<class TdataCl> void Slave<TdataCl>::proc_resp(){
  Td SData = 0;
  while(true) {
    wait(); // For response event

    // Set response data
    resp.SResp = OCP_SRESP_DVA;
    m_DataCl->SputSData(SData);
    m_DataCl->SputSResp(resp.SResp);
#ifdef DEBUG_G1
    cout << "Slave sent response " << resp.SResp
	 << " time " << sc_time_stamp().to_seconds()
	 << " data " << SData << endl;
#endif
    // Send response when master can receive it, else wait another cycle
    // Notice that if the master is busy, we may lose response events.
    // You may want to add a response thread busy checking in the
    // request thread.
    if (!tpP->SgetMbusy()) {
      // Send response
      tpP->SputResponse();
      SData++;
    }
    else
      wait(clk->posedge_event()); 

  }
} // end of method

template<class TdataCl>
void Slave<TdataCl>::end_of_elaboration()
{
  sc_module::end_of_elaboration();

  // Get data structure
  m_DataCl = tpP->GetDataCl();

  // Get parameters
  m_ParamCl = tpP->GetParamCl();
}

// ----------------------------------------------------------------------------
//
//  Instantiation of the Slave
//
// ----------------------------------------------------------------------------
template class Slave<OCP_TL1_DataCl< int, int >  >; 

