// 
//  (c) Copyright OCP-IP 2003
//  OCP-IP Confidential and Proprietary
//
// ============================================================================
//      Project : OCP SLD WG
//       Author : Alan Kamas, for Sonics, Inc.
//         $Id: ocp_tl1_slave_multiport.h,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : OCP TL1 Slave multiport declaration.
//                These methods are implemented in the Channel
//                (see ocp_tl1_channel.h)
//
// ============================================================================

#ifndef OCP_TL1_SLAVEMULTIPORT_H
#define OCP_TL1_SLAVEMULTIPORT_H

#include "multiport_event_finder.h"
#include "ocp_tl1_slave_if.h"


template <class TdataCl> class OCP_TL1_SlaveMultiPort
: public sc_port<OCP_TL1_SlaveIF<TdataCl>, 0>
{
    public:

        // Constructor
        OCP_TL1_SlaveMultiPort(const char* name)
            : sc_port<OCP_TL1_SlaveIF<TdataCl>, 0>(name)
        {
            // do nothing
        }

        // Access to the "in-band" events of the OCP TL1 Channel using event finders
	sc_event_finder& RequestStartEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::RequestStartEvent, myPort ); }
	sc_event_finder& RequestEndEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::RequestEndEvent, myPort ); }
	sc_event_finder& DataRequestStartEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::DataRequestStartEvent, myPort ); }
	sc_event_finder& DataRequestEndEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::DataRequestEndEvent, myPort ); }
	sc_event_finder& ResponseStartEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::ResponseStartEvent, myPort ); }
	sc_event_finder& ResponseEndEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::ResponseEndEvent, myPort ); }

        // Access to the Slave Sideband events of the OCP TL1 Channel using event finders
	sc_event_finder& SidebandMErrorEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandMErrorEvent, myPort ); }
	sc_event_finder& SidebandMFlagEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandMFlagEvent, myPort ); }

        // Access to OCP System Sideband Events of the OCP TL1 Channel using event finders
	sc_event_finder& SidebandControlBusyEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandControlBusyEvent, myPort ); }
	sc_event_finder& SidebandStatusEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandStatusEvent, myPort ); }
	sc_event_finder& SidebandStatusBusyEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandStatusBusyEvent, myPort ); }

        // Access to OCP Core Sideband Events of the OCP TL1 Channel using event finders
	sc_event_finder& SidebandControlEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandControlEvent, myPort ); }
	sc_event_finder& SidebandControlWrEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandControlWrEvent, myPort ); }
	sc_event_finder& SidebandStatusRdEvent(int myPort=0) const { return *new multiport_event_finder_t<OCP_TL1_SlaveIF<TdataCl> >( *this, &OCP_TL1_SlaveIF<TdataCl>::SidebandStatusRdEvent, myPort ); }

};

#endif   // OCP_TL1_SLAVEMULTIPORT_H

