// 
//  Copyright 2003 OCP-IP
//  OCP-IP Confidential & Proprietary
//
// ============================================================================
//      Project : OCP SLD WG, OCP Transaction Level
//       Author : Norman Weyrich, Synopsys Inc.
//                (modified by Joe Chou, Sonics Inc.)
//         $Id: ocp_tl2_top0.cpp,v 1.2 2004/09/05 17:57:56 halexan Exp $
//
//  Description : OCP TL2 Poin-to-Point Connection (One Master One Slave)
// ============================================================================

#include "ocp_tl2_master.h"
#include "ocp_tl2_slave.h"
#include "ocp_tl2_data_cl.h"
#include "tl_channel.h"  // needs ocp_tl2_globals.h and therefore must be
                         // included after ocp_tl2_master.h or ocp_tl2_slave.h

int sc_main(int, char*[])
{
  //
  bool SynchronChannel = true;
  bool Pipelined = true;
  bool WriteResponse = false;

  // create an OCP channel, the channel's master and slave
  TL_Channel< OCP_TL2_TEMPL_DATA_CL >
      ch1("ch1",SynchronChannel,true);
  OCP_TL2_Slave< OCP_TL2_TEMPL_DATA_CL >
      sl1("sl1",1,0x0,0x3FF,Pipelined,WriteResponse,2,2,2,20);
  OCP_TL2_Master< OCP_TL2_TEMPL_DATA_CL >
      ma1("ma1",1,1,Pipelined,WriteResponse,1,1);

  // connect the channel to the master's MasterP port and the slave's
  // SlaveP port
  ma1.MasterP(ch1);
  sl1.SlaveP(ch1);

  // run the simulation for 1000 cycles
  sc_start(1000,TL_TIME_SCALE);

  //
  cout << "OCP_TL2_Top0 : Program finished at " 
       << sc_time_stamp().to_double() << endl;

  return (0);
}
